/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.notification.service;

import de.justsoftware.mobile.gateway.notification.model.MobilePushToken;
import de.justsoftware.mobile.gateway.notification.model.Notification;
import de.justsoftware.mobile.gateway.notification.model.NotificationsCount;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$archiveNotification$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$getNotifications$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$openNotifications$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$registerAndroid$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$registerIos$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$unregisterPushToken$;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0016\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J(\u0010'\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0012J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0003H\u0012J\u0018\u0010)\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0012J\u0012\u0010*\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0012J\u001a\u0010+\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010#\u001a\u00020$H\u0012J\u0018\u0010,\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;", "", "notificationApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "archiveAllNotificationsUri", "Ljava/net/URI;", "notificationsCountUri", "openNotificationsUri", "getNotifications", "", "Lde/justsoftware/mobile/gateway/notification/model/Notification;", "state", "limit", "", "date", "locale", "getNotificationsCount", "Lde/justsoftware/mobile/gateway/notification/model/NotificationsCount;", "archiveAllNotifications", "archiveNotification", "", "notificationId", "openNotifications", "notificationIds", "markNotification", "action", "registerAndroid", "Lde/justsoftware/mobile/gateway/notification/model/MobilePushToken;", "pushToken", "publicKey", "registerIos", "silenceAlerts", "", "unregisterPushToken", "platform", "notificationsUri", "archiveNotificationUri", "markNotificationUri", "registerAndroidUri", "registerIosUri", "unregisterPushTokenUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nNotificationApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationApiGatewayService.kt\nde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,138:1\n28#2:139\n28#2:140\n56#2:141\n56#2:142\n59#2:143\n56#2:144\n34#2:145\n34#2:146\n62#2:147\n*S KotlinDebug\n*F\n+ 1 NotificationApiGatewayService.kt\nde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService\n*L\n31#1:139\n40#1:140\n42#1:141\n46#1:142\n49#1:143\n58#1:144\n69#1:145\n76#1:146\n82#1:147\n*E\n"})
public class NotificationApiGatewayService {
    @NotNull
    private final String notificationApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI archiveAllNotificationsUri;
    @NotNull
    private final URI notificationsCountUri;
    @NotNull
    private final URI openNotificationsUri;

    public NotificationApiGatewayService(@Value(value="${just.notification.api.url}") @NotNull String notificationApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)notificationApiUrl, (String)"notificationApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.notificationApiUrl = notificationApiUrl;
        this.webClient = webClient;
        this.archiveAllNotificationsUri = UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/archive"), null, (int)2, null);
        this.notificationsCountUri = UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/count"), null, (int)2, null);
        this.openNotificationsUri = UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/open"), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Notification> getNotifications(@NotNull String state, int limit, @NotNull String date, @NotNull String locale) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        WebClient webClient = this.webClient;
        URI uRI = this.notificationsUri(state, limit, date, locale);
        boolean $i$f$get = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getNotifications$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NotificationsCount getNotificationsCount() {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.notificationsCountUri;
        boolean $i$f$get = false;
        return (NotificationsCount)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> archiveAllNotifications() {
        void $this$put$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.archiveAllNotificationsUri;
        boolean $i$f$put = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void archiveNotification(@NotNull String notificationId) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.archiveNotificationUri(notificationId);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new archiveNotification$$inlined$put$1((WebClient)$this$put$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void openNotifications(@NotNull List<String> notificationIds) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        WebClient webClient = this.webClient;
        URI uri$iv = this.openNotificationsUri;
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new openNotifications$$inlined$put$1((WebClient)$this$put$iv, uri$iv, notificationIds, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void markNotification(@NotNull String notificationId, @NotNull String action) {
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        WebClient webClient = this.webClient;
        URI uRI = this.markNotificationUri(notificationId, action);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobilePushToken registerAndroid(@NotNull String pushToken, @Nullable String publicKey) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uri$iv = this.registerAndroidUri(publicKey);
        boolean $i$f$post = false;
        return (MobilePushToken)BuildersKt.runBlocking$default(null, (Function2)((Function2)new registerAndroid$$inlined$post$1((WebClient)$this$post$iv, uri$iv, (Object)pushToken, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobilePushToken registerIos(@NotNull String pushToken, @Nullable String publicKey, boolean silenceAlerts) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uri$iv = this.registerIosUri(publicKey, silenceAlerts);
        boolean $i$f$post = false;
        return (MobilePushToken)BuildersKt.runBlocking$default(null, (Function2)((Function2)new registerIos$$inlined$post$1((WebClient)$this$post$iv, uri$iv, (Object)pushToken, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterPushToken(@NotNull String platform, @NotNull String pushToken) {
        void uri$iv;
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uRI = this.unregisterPushTokenUri(platform, pushToken);
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new unregisterPushToken$$inlined$delete$1((WebClient)$this$delete$iv, (URI)uri$iv, null)), (int)1, null);
    }

    private URI notificationsUri(String state, int limit, String date, String locale) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"status", (Object)state), TuplesKt.to((Object)"maxElements", (Object)limit), TuplesKt.to((Object)"date", (Object)date), TuplesKt.to((Object)"locale", (Object)locale)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        return UrisKt.buildUri((String)(this.notificationApiUrl + "/notification"), (Map)params);
    }

    private URI archiveNotificationUri(String notificationId) {
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/archive/" + notificationId), null, (int)2, null);
    }

    private URI markNotificationUri(String notificationId, String action) {
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/" + notificationId + "/" + action), null, (int)2, null);
    }

    private URI registerAndroidUri(String publicKey) {
        Map map;
        Map $this$registerAndroidUri_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        if (publicKey != null) {
            $this$registerAndroidUri_u24lambda_u240.put("publicKey", publicKey);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri((String)(this.notificationApiUrl + "/mobilepush/android"), (Map)params);
    }

    private URI registerIosUri(String publicKey, boolean silenceAlerts) {
        Map map;
        Map $this$registerIosUri_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$registerIosUri_u24lambda_u241.put("silenceAlerts", silenceAlerts);
        if (publicKey != null) {
            $this$registerIosUri_u24lambda_u241.put("publicKey", publicKey);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri((String)(this.notificationApiUrl + "/mobilepush/ios"), (Map)params);
    }

    private URI unregisterPushTokenUri(String platform, String pushToken) {
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/mobilepush/" + platform + "/" + pushToken), null, (int)2, null);
    }
}

