/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import com.unboundid.scim2.common.types.UserResource;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.persistence.model.DbAuditModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="ScimUserResource")
@ParametersAreNonnullByDefault
public class DbScimUserResource
extends DbAuditModel {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private UUID id;
    @Column(nullable=false)
    private UUID tenantId;
    @Column(nullable=false)
    private UUID profileId;
    @JdbcTypeCode(value=3001)
    @Column(nullable=false)
    private UserResource data;

    public DbScimUserResource() {
    }

    public DbScimUserResource(UUID profileId, TenantId tenantId, UserResource resource) {
        this.tenantId = (UUID)tenantId.getId();
        this.profileId = profileId;
        this.data = resource;
    }

    @Nonnull
    public UserResource getData() {
        return this.data;
    }

    public void setData(UserResource data) {
        this.data = data;
    }

    @Nonnull
    public UUID getProfileId() {
        return this.profileId;
    }

    public void setProfileId(UUID profileId) {
        this.profileId = profileId;
    }

    @CheckForNull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @Nonnull
    public TenantId getTenantId() {
        return new TenantId(this.tenantId);
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = (UUID)tenantId.getId();
    }
}

