/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.model.usergroup;

import com.fasterxml.jackson.annotation.JsonCreator;
import de.justsoftware.justimport.domain.model.common.AbstractUUIDBasedId;
import de.justsoftware.justimport.domain.model.common.IdParser;
import de.justsoftware.justimport.domain.model.common.ItemType;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UserGroupId
extends AbstractUUIDBasedId
implements InternalId {
    public UserGroupId(UUID id) {
        super(id, ItemType.USER_GROUP);
    }

    public UserGroupId(String id) {
        this(UUID.fromString(id));
    }

    @Nonnull
    public static UserGroupId random() {
        return new UserGroupId(UUID.randomUUID());
    }

    @JsonCreator
    @Nonnull
    public static UserGroupId parse(String groupId) {
        return (UserGroupId)IdParser.parse((ItemType)ItemType.USER_GROUP, (String)groupId, UserGroupId::new);
    }
}

