/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.common.document.model.DocumentBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.item.model.ItemId;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface DocumentDAO {
    public void repairMissingLastVersionLink();

    public void updateLastVersions(Set<DocumentId> var1);

    public void repairMissingLastPublicVersionLink();

    public void updateLastPublicVersions(Set<DocumentId> var1);

    @Nonnull
    public ImmutableBiMap<DocumentId, DocumentVersionId> getLastVersions(Set<DocumentId> var1, PublishedFilter var2);

    @Nonnull
    public ImmutableMap<DocumentId, Integer> getLastVersionNumbers(Set<DocumentId> var1);

    public void prepareDelete(Set<DocumentId> var1);

    public void deleteFinally(Set<DocumentId> var1);

    public void updateMetadata(DocumentId var1, @Nullable String var2, @Nullable String var3);

    @Nonnull
    public ImmutableMap<DocumentId, DocumentBO> getDocumentsById(Set<DocumentId> var1);

    @Nonnull
    public ImmutableSetMultimap<ItemId, DocumentId> getDocumentIdsPerItems(Set<ItemId> var1);

    public void unlinkLastVersionUpdatedByChanges(Set<DocumentVersionId> var1);

    public void unlinkLastPublishedVersionUpdatedByChanges(Set<DocumentVersionId> var1);

    public void deleteAllWithoutVersions();

    public void prepareDeleteItem(ItemId var1);
}

