/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.kafka;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationType;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NotificationConnector {
    private final String _appId = "drive";
    @Nonnull
    private final NotificationProducer _notificationProducer;

    @Autowired
    NotificationConnector(NotificationProducer notificationProducer) {
        this._notificationProducer = notificationProducer;
    }

    public void sendShareRequestNotification(TenantId tenantId, String shareName, ItemId shareId, String requestor, ImmutableSet<String> receiverIds) {
        Map<Locale, String> localText = Map.of(Locale.GERMAN, String.format("%s bittet um Zugang zum Laufwerk \"%s\".", requestor, shareName), Locale.ENGLISH, String.format("%s has requested access to the share \"%s\".", requestor, shareName));
        this.sendNotifications(tenantId, shareName, shareId, receiverIds, NotificationType.DRIVE_SHARE_ACCESS_REQUEST, localText);
    }

    private void sendNotifications(TenantId tenantId, String shareName, ItemId shareId, ImmutableSet<String> receiverIds, NotificationType notificationType, Map<Locale, String> localText) {
        if (!receiverIds.isEmpty()) {
            this._notificationProducer.dispatchNotification(Notification.builder((UUID)((UUID)tenantId.getId()), (String)"drive", (String)shareName, (String)localText.get(Locale.GERMAN), (NotificationType)notificationType).withLocalizedText(localText).withReceivers(receiverIds).withPayload("drive").withTargetId((String)shareId.getId()).build());
        }
    }
}

