/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.change.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.common.change.model.ChangeVersionUpdateModel;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class DriveChangeVersionConsumer
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.change.version";
    @VisibleForTesting
    static final String EXPIRATION_DATE = "expirationDate";
    @VisibleForTesting
    static final String FIRST_PUBLISHED_DATE = "firstPublishedDate";
    @VisibleForTesting
    static final String FIRST_PUBLISHED_VERSION = "firstPublishedVersion";
    @VisibleForTesting
    static final String FIRST_VERSION = "firstVersion";
    private static final int CHUNK_SIZE = Math.min(10, 10);
    private final ChangeModificationService _changeModificationService;

    @Autowired
    public DriveChangeVersionConsumer(KafkaConfigurationProvider configurationProvider, TransactionSupport transactionSupport, ChangeModificationService changeModificationService) {
        this(configurationProvider.stringConsumer("just.drive.DriveChangeVersionConsumer", CHUNK_SIZE), transactionSupport, changeModificationService);
    }

    @VisibleForTesting
    DriveChangeVersionConsumer(@Nullable Consumer<String, String> consumer, TransactionSupport transactionSupport, ChangeModificationService changeModificationService) {
        super(consumer, transactionSupport, "just.change.version");
        this._changeModificationService = changeModificationService;
    }

    protected void process(ConsumerRecords<String, String> records, java.util.function.Consumer<Runnable> afterCommitCallbackConsumer) {
        HashMap result = new HashMap();
        for (ConsumerRecord record : records) {
            this.processRecord(record, result);
        }
        this._changeModificationService.updateChangeVersions(result, afterCommitCallbackConsumer);
    }

    void processRecord(ConsumerRecord<String, String> record, Map<DocumentVersionId, ChangeVersionUpdateModel> result) {
        DocumentVersionId change = new DocumentVersionId((String)record.key());
        ChangeVersionUpdateModel.ChangeVersionUpdateModelBuilder builder = ChangeVersionUpdateModel.builder((DocumentVersionId)change);
        String value = (String)record.value();
        if (value != null) {
            JsonNode json = this.parseJson(value);
            builder.setFirstPublishedDate((Instant)DriveChangeVersionConsumer.parseDate((JsonNode)json, (String)"firstPublishedDate").orNull());
            builder.setExpirationDate((Instant)DriveChangeVersionConsumer.parseDate((JsonNode)json, (String)"expirationDate").orNull());
            builder.setFirstPublishedVersion((String)DriveChangeVersionConsumer.parseString((JsonNode)json, (String)"firstPublishedVersion").transform(String::trim).orNull());
            builder.setFirstVersion((String)DriveChangeVersionConsumer.parseString((JsonNode)json, (String)"firstVersion").transform(String::trim).orNull());
        }
        result.put(change, builder.build());
    }
}

