/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.model.persistence.conversion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public class ConversionLogEntry {
    public static final String LAST_UNTRACKED_CONVERTER_VERSION = "1.0.33";
    private final DocumentType _sourceType;
    private final DocumentType _targetType;
    private final long _timestamp;
    private final DocumentStatus _status;
    private final String _converterName;
    private final String _converterVersion;

    @JsonCreator
    @ParametersAreNonnullByDefault
    public ConversionLogEntry(@JsonProperty(value="sourceType") DocumentType sourceType, @JsonProperty(value="targetType") DocumentType targetType, @JsonProperty(value="timestamp") @Nonnegative long timestamp, @JsonProperty(value="status") DocumentStatus status, @Nullable @JsonProperty(value="converterName", required=false) String converterName, @Nullable @JsonProperty(value="converterVersion", required=false) String converterVersion) {
        this._sourceType = sourceType;
        this._targetType = targetType;
        this._timestamp = timestamp;
        this._status = status;
        this._converterName = converterName != null ? converterName : sourceType.getConverterNameForVersionOneZeroX();
        this._converterVersion = converterVersion != null ? converterVersion : LAST_UNTRACKED_CONVERTER_VERSION;
    }

    @Nonnull
    public DocumentType getSourceType() {
        return this._sourceType;
    }

    @Nonnull
    public DocumentType getTargetType() {
        return this._targetType;
    }

    @Nonnegative
    public long getTimestamp() {
        return this._timestamp;
    }

    @Nonnull
    public DocumentStatus getStatus() {
        return this._status;
    }

    @Nonnull
    public String getConverterName() {
        return this._converterName;
    }

    @Nonnull
    public String getConverterVersion() {
        return this._converterVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sourceType", (Object)this.getSourceType()).add("targetType", (Object)this.getTargetType()).add("timestamp", this.getTimestamp()).add("status", (Object)this.getStatus()).add("converterName", (Object)this.getConverterName()).add("converterVersion", (Object)this.getConverterVersion()).toString();
    }

    @Nonnull
    public static Predicate<ConversionLogEntry> composeTargetFilter(@Nonnull DocumentType targetType) {
        return input -> input != null && input.getTargetType().equals((Object)targetType);
    }
}

