/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.oauth2.JustAuthenticationProvider$retrieveUser$;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.LoginDto;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;", "Lorg/springframework/security/authentication/dao/AbstractUserDetailsAuthenticationProvider;", "toroInternalUrl", "", "(Ljava/lang/String;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "getToroInternalUrl", "()Ljava/lang/String;", "additionalAuthenticationChecks", "", "userDetails", "Lorg/springframework/security/core/userdetails/UserDetails;", "authentication", "Lorg/springframework/security/authentication/UsernamePasswordAuthenticationToken;", "retrieveUser", "username", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nJustAuthenticationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JustAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/JustAuthenticationProvider\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,44:1\n43#2:45\n*S KotlinDebug\n*F\n+ 1 JustAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/JustAuthenticationProvider\n*L\n38#1:45\n*E\n"})
public class JustAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    @NotNull
    private final String toroInternalUrl;
    @NotNull
    private final RestClient restClient;

    public JustAuthenticationProvider(@Value(value="${just.toro.internal}") @NotNull String toroInternalUrl) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        this.toroInternalUrl = toroInternalUrl;
        this.setForcePrincipalAsString(true);
        RestClient restClient = RestClient.create();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"create(...)");
        this.restClient = restClient;
    }

    @NotNull
    public String getToroInternalUrl() {
        return this.toroInternalUrl;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    protected void additionalAuthenticationChecks(@Nullable UserDetails userDetails, @Nullable UsernamePasswordAuthenticationToken authentication) {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UserDetails retrieveUser(@NotNull String username, @NotNull UsernamePasswordAuthenticationToken authentication) {
        void $this$body$iv;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        String password = authentication.getCredentials().toString();
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.getRestClient().post().uri(this.getToroInternalUrl() + "/auth/login/", new Object[0])).accept(mediaTypeArray)).body((Object)new LoginDto(username, password)).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec responseSpec2 = responseSpec;
        boolean $i$f$body = false;
        JustUser justUser = (JustUser)$this$body$iv.body((ParameterizedTypeReference)new retrieveUser$$inlined$body$1());
        if (justUser == null) {
            throw new UsernameNotFoundException("User " + username + " not found");
        }
        return (UserDetails)justUser;
    }
}

