/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.security;

import de.justsoftware.admin.security.JustOpaqueTokenIntrospector;
import de.justsoftware.admin.security.WebSecurityConfiguration;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

@Configuration
@EnableWebSecurity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fBA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0001\u0010\b\u001a\u00020\u0005\u0012\b\b\u0001\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/admin/security/WebSecurityConfiguration;", "", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "checkTokenEndpoint", "", "clientId", "clientSecret", "graphiQlPath", "internalBasePath", "(Lde/justsoftware/jwtfilter/verifier/JwtVerifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "securityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "Companion", "admin-service"})
public class WebSecurityConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JwtVerifier jwtVerifier;
    @NotNull
    private final String checkTokenEndpoint;
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final String graphiQlPath;
    @NotNull
    private final String internalBasePath;
    @NotNull
    public static final String CLOUD_REGISTRATION_SCOPE = "SCOPE_cloud-registration";

    @Autowired
    public WebSecurityConfiguration(@NotNull JwtVerifier jwtVerifier, @Value(value="${just.admin.oauth2.resource.check_token_endpoint}") @NotNull String checkTokenEndpoint, @Value(value="${just.admin.oauth2.resource.client_id}") @NotNull String clientId, @Value(value="${just.admin.oauth2.resource.client_secret}") @NotNull String clientSecret, @Value(value="${dgs.graphql.graphiql.path}") @NotNull String graphiQlPath, @Value(value="${internal.base-path}") @NotNull String internalBasePath) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkNotNullParameter((Object)checkTokenEndpoint, (String)"checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)graphiQlPath, (String)"graphiQlPath");
        Intrinsics.checkNotNullParameter((Object)internalBasePath, (String)"internalBasePath");
        this.jwtVerifier = jwtVerifier;
        this.checkTokenEndpoint = checkTokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.graphiQlPath = graphiQlPath;
        this.internalBasePath = internalBasePath;
    }

    @Bean
    @NotNull
    public SecurityFilterChain securityFilterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Object object = http.sessionManagement(WebSecurityConfiguration::securityFilterChain$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::securityFilterChain$lambda$1).anonymous(Customizer.withDefaults()).headers(WebSecurityConfiguration::securityFilterChain$lambda$2).authorizeHttpRequests(arg_0 -> WebSecurityConfiguration.securityFilterChain$lambda$3(this, arg_0)).oauth2ResourceServer(arg_0 -> WebSecurityConfiguration.securityFilterChain$lambda$5(this, arg_0)).addFilterAfter((Filter)new JwtAuthenticationProcessingFilter(this.jwtVerifier), AbstractPreAuthenticatedProcessingFilter.class).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void securityFilterChain$lambda$0(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void securityFilterChain$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void securityFilterChain$lambda$2(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void securityFilterChain$lambda$3(WebSecurityConfiguration this$0, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String[] stringArray = new String[]{this$0.graphiQlPath};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{this$0.internalBasePath + "/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/api/cloudregistration/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).hasAuthority(CLOUD_REGISTRATION_SCOPE);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    private static final void securityFilterChain$lambda$5$lambda$4(WebSecurityConfiguration this$0, OAuth2ResourceServerConfigurer.OpaqueTokenConfigurer opaqueTokenCustomizer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JustOpaqueTokenIntrospector justTokenIntrospector = new JustOpaqueTokenIntrospector(this$0.checkTokenEndpoint, this$0.clientId, this$0.clientSecret);
        opaqueTokenCustomizer.introspector((OpaqueTokenIntrospector)justTokenIntrospector);
    }

    private static final void securityFilterChain$lambda$5(WebSecurityConfiguration this$0, OAuth2ResourceServerConfigurer resourceServerCustomizer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)resourceServerCustomizer, (String)"resourceServerCustomizer");
        resourceServerCustomizer.opaqueToken(arg_0 -> WebSecurityConfiguration.securityFilterChain$lambda$5$lambda$4(this$0, arg_0));
    }
}

