/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher.configuration;

import de.justsoftware.admin.kafka.publisher.configuration.KafkaProducerConfig;
import de.justsoftware.admin.kafka.serializer.ClientRegistrationSerializer;
import de.justsoftware.generated.proto.ClientRegistration;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import de.justsoftware.permission.client.PermissionOffsetChecker;
import de.justsoftware.permission.client.kafka.PermissionItemKafkaProducer;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentKafkaProducer;
import java.time.Clock;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@DependsOn(value={"liquibase"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0011\u0018\u00002\u00020\u0001:\u0001\u001aB\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0012J\r\u0010\t\u001a\u00020\nH\u0011\u00a2\u0006\u0002\b\u000bJ\b\u0010\f\u001a\u00020\bH\u0012J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eH\u0017J1\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0011\u00a2\u0006\u0002\b\u0015J\u0019\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0011\u00a2\u0006\u0002\b\u0016J1\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0011\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/admin/kafka/publisher/configuration/KafkaProducerConfig;", "", "bootstrapServers", "", "maxChunkSize", "", "(Ljava/lang/String;I)V", "cleaningConsumerConfig", "Ljava/util/Properties;", "clock", "Ljava/time/Clock;", "clock$admin_service", "closingKafkaProducerConfig", "createOAuthClientProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "Lde/justsoftware/generated/proto/ClientRegistration;", "permissionItemProducer", "Lde/justsoftware/permission/client/kafka/PermissionItemKafkaProducer;", "permissionProducer", "permissionOffsetChecker", "Lde/justsoftware/permission/client/PermissionOffsetChecker;", "permissionItemProducer$admin_service", "permissionProducer$admin_service", "singleRoleAssignmentProducer", "Lde/justsoftware/permission/client/kafka/SingleRoleAssignmentKafkaProducer;", "singleRoleAssignmentProducer$admin_service", "ClosingKafkaProducer", "admin-service"})
public class KafkaProducerConfig {
    @NotNull
    private final String bootstrapServers;
    private final int maxChunkSize;

    public KafkaProducerConfig(@Value(value="${spring.kafka.bootstrap-servers}") @NotNull String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:100}") int maxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
        this.maxChunkSize = maxChunkSize;
    }

    @Bean
    @NotNull
    public PermissionItemKafkaProducer permissionItemProducer$admin_service(@NotNull KafkaCleaningProducer<String, String> permissionProducer, @NotNull PermissionOffsetChecker permissionOffsetChecker, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(permissionProducer, (String)"permissionProducer");
        Intrinsics.checkNotNullParameter((Object)permissionOffsetChecker, (String)"permissionOffsetChecker");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new PermissionItemKafkaProducer(permissionProducer, permissionOffsetChecker, clock);
    }

    @Bean
    @NotNull
    public SingleRoleAssignmentKafkaProducer singleRoleAssignmentProducer$admin_service(@NotNull KafkaCleaningProducer<String, String> permissionProducer, @NotNull PermissionOffsetChecker permissionOffsetChecker, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(permissionProducer, (String)"permissionProducer");
        Intrinsics.checkNotNullParameter((Object)permissionOffsetChecker, (String)"permissionOffsetChecker");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new SingleRoleAssignmentKafkaProducer(permissionProducer, permissionOffsetChecker, clock);
    }

    @Bean(destroyMethod="close")
    @NotNull
    public KafkaCleaningProducer<String, String> permissionProducer$admin_service() {
        return (KafkaCleaningProducer)new KafkaCleaningProducerImpl((Producer)new ClosingKafkaProducer(this.closingKafkaProducerConfig()), arg_0 -> KafkaProducerConfig.permissionProducer$lambda$0(this, arg_0));
    }

    @Bean(destroyMethod="close")
    @NotNull
    public KafkaCleaningProducer<String, ClientRegistration> createOAuthClientProducer() {
        return (KafkaCleaningProducer)new KafkaCleaningProducerImpl((Producer)new KafkaProducer(this.closingKafkaProducerConfig(), (Serializer)new StringSerializer(), (Serializer)new ClientRegistrationSerializer()), arg_0 -> KafkaProducerConfig.createOAuthClientProducer$lambda$1(this, arg_0));
    }

    @Bean
    @NotNull
    public Clock clock$admin_service() {
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone(...)");
        return clock;
    }

    private Properties cleaningConsumerConfig() {
        Properties properties;
        Properties $this$cleaningConsumerConfig_u24lambda_u242 = properties = new Properties();
        boolean bl = false;
        $this$cleaningConsumerConfig_u24lambda_u242.put("bootstrap.servers", this.bootstrapServers);
        $this$cleaningConsumerConfig_u24lambda_u242.put("enable.auto.commit", "false");
        $this$cleaningConsumerConfig_u24lambda_u242.put("auto.offset.reset", "earliest");
        $this$cleaningConsumerConfig_u24lambda_u242.put("max.poll.records", (Object)this.maxChunkSize);
        return properties;
    }

    private Properties closingKafkaProducerConfig() {
        Properties properties;
        Properties $this$closingKafkaProducerConfig_u24lambda_u243 = properties = new Properties();
        boolean bl = false;
        $this$closingKafkaProducerConfig_u24lambda_u243.put("bootstrap.servers", this.bootstrapServers);
        $this$closingKafkaProducerConfig_u24lambda_u243.put("acks", "all");
        $this$closingKafkaProducerConfig_u24lambda_u243.put("retries", (Object)0);
        $this$closingKafkaProducerConfig_u24lambda_u243.put("batch.size", (Object)16384);
        $this$closingKafkaProducerConfig_u24lambda_u243.put("linger.ms", (Object)1);
        $this$closingKafkaProducerConfig_u24lambda_u243.put("buffer.memory", (Object)0x2000000);
        return properties;
    }

    private static final Consumer permissionProducer$lambda$0(KafkaProducerConfig this$0, TopicPartition it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)it, (Properties)this$0.cleaningConsumerConfig());
    }

    private static final Consumer createOAuthClientProducer$lambda$1(KafkaProducerConfig this$0, TopicPartition it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)it, (Properties)this$0.cleaningConsumerConfig());
    }
}

