/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.Color;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.graphql.generated.types.TenantInvitation;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.TenantId;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0017J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J&\u0010\u0015\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\nH\u0017J&\u0010\u0018\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/TenantSettingsFetcher;", "", "applicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "(Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "getApplicationService", "()Lde/justsoftware/admin/application/web/TenantApplicationService;", "color", "Lde/justsoftware/admin/graphql/generated/types/Color;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "deeplKey", "", "logoId", "Lde/justsoftware/admin/id/DocumentId;", "setTenantInvitationActive", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "isInvitationActive", "", "setTenantLogo", "tenantInvitation", "Lde/justsoftware/admin/graphql/generated/types/TenantInvitation;", "updateDeeplKey", "admin-service"})
public class TenantSettingsFetcher {
    @NotNull
    private final TenantApplicationService applicationService;

    public TenantSettingsFetcher(@NotNull TenantApplicationService applicationService) {
        Intrinsics.checkNotNullParameter((Object)applicationService, (String)"applicationService");
        this.applicationService = applicationService;
    }

    @NotNull
    public TenantApplicationService getApplicationService() {
        return this.applicationService;
    }

    @DgsData(parentType="Tenant", field="deeplKey")
    @Nullable
    public String deeplKey(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        return this.getApplicationService().getTenantSettings(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)).getDeeplKey();
    }

    @DgsData(parentType="Tenant", field="color")
    @NotNull
    public Color color(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        TenantSettings settings = this.getApplicationService().getTenantSettings(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return new Color.Builder().withCustom(settings.getGlobalHighlightColor()).withDefault(TenantSettings.Companion.Defaults.INSTANCE.getGlobalHighlightColor()).build();
    }

    @DgsData(parentType="Tenant", field="logoId")
    @Nullable
    public DocumentId logoId(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        return this.getApplicationService().getTenantSettings(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)).getLogoId();
    }

    @DgsData(parentType="Tenant", field="tenantInvitation")
    @Nullable
    public TenantInvitation tenantInvitation(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Tenant tenant = (Tenant)dfe.getSource();
        de.justsoftware.admin.domain.tenant.model.TenantInvitation tenantInvitation = this.getApplicationService().getTenantInvitation(tenant.getId(), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return tenantInvitation != null ? ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.TenantInvitation)tenantInvitation) : null;
    }

    @DgsMutation(field="setTenantInvitationActive")
    @NotNull
    public Tenant setTenantInvitationActive(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId, @InputArgument boolean isInvitationActive) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.getApplicationService().setTenantInvitationActive(tenantId, isInvitationActive, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="setTenantLogo")
    @NotNull
    public Tenant setTenantLogo(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId, @InputArgument @Nullable DocumentId logoId) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.getApplicationService().setLogo(tenantId, logoId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateDeeplKey")
    @NotNull
    public Tenant updateDeeplKey(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull TenantId tenantId, @InputArgument @Nullable String deeplKey) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.getApplicationService().updateDeeplKey(tenantId, deeplKey, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }
}

