/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web.wiki;

import de.justsoftware.admin.application.web.wiki.WikiSettings;
import de.justsoftware.admin.application.web.wiki.WikiSettingsInput;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.wiki.WikiAppConnector;
import de.justsoftware.admin.id.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/admin/application/web/wiki/WikiSettingsApplicationService;", "", "wikiAppConnector", "Lde/justsoftware/admin/connector/wiki/WikiAppConnector;", "(Lde/justsoftware/admin/connector/wiki/WikiAppConnector;)V", "getSettings", "Lde/justsoftware/admin/application/web/wiki/WikiSettings;", "autContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "updateSettings", "", "input", "Lde/justsoftware/admin/application/web/wiki/WikiSettingsInput;", "admin-service"})
public class WikiSettingsApplicationService {
    @NotNull
    private final WikiAppConnector wikiAppConnector;

    public WikiSettingsApplicationService(@NotNull WikiAppConnector wikiAppConnector) {
        Intrinsics.checkNotNullParameter((Object)wikiAppConnector, (String)"wikiAppConnector");
        this.wikiAppConnector = wikiAppConnector;
    }

    @NotNull
    public WikiSettings getSettings(@NotNull AuthorizationContext autContext) {
        Intrinsics.checkNotNullParameter((Object)autContext, (String)"autContext");
        autContext.checkTenantManager();
        TenantId tenantId = autContext.getNonNullTenantId();
        return new WikiSettings(tenantId, this.wikiAppConnector.getArticleVersionHistoryReadPermission(tenantId));
    }

    public void updateSettings(@NotNull WikiSettingsInput input, @NotNull AuthorizationContext autContext) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)autContext, (String)"autContext");
        autContext.checkTenantManager();
        TenantId tenantId = autContext.getNonNullTenantId();
        if (input.getRoleToReadVersionHistory() != null) {
            this.wikiAppConnector.setArticleVersionHistoryReadPermission(input.getRoleToReadVersionHistory(), tenantId);
        }
    }
}

