/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.web.people.PeopleSettings;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.people.PeopleConnector;
import de.justsoftware.admin.graphql.generated.types.PeopleSettingsInput;
import de.justsoftware.admin.id.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/admin/application/web/PeopleSettingsApplicationService;", "", "peopleConnector", "Lde/justsoftware/admin/connector/people/PeopleConnector;", "(Lde/justsoftware/admin/connector/people/PeopleConnector;)V", "getBirthdayListEnabled", "Lde/justsoftware/admin/application/web/people/PeopleSettings;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "setBirthdayListEnabled", "", "peopleSettingsInput", "Lde/justsoftware/admin/graphql/generated/types/PeopleSettingsInput;", "admin-service"})
public class PeopleSettingsApplicationService {
    @NotNull
    private final PeopleConnector peopleConnector;

    public PeopleSettingsApplicationService(@NotNull PeopleConnector peopleConnector) {
        Intrinsics.checkNotNullParameter((Object)peopleConnector, (String)"peopleConnector");
        this.peopleConnector = peopleConnector;
    }

    @NotNull
    public PeopleSettings getBirthdayListEnabled(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getNonNullTenantId();
        authContext.checkTenantManager(tenantId);
        return new PeopleSettings(tenantId, this.peopleConnector.getBirthdayListEnabled(tenantId));
    }

    public void setBirthdayListEnabled(@NotNull AuthorizationContext authContext, @NotNull PeopleSettingsInput peopleSettingsInput) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)peopleSettingsInput, (String)"peopleSettingsInput");
        TenantId tenantId = authContext.getNonNullTenantId();
        authContext.checkTenantManager(tenantId);
        this.peopleConnector.setBirthdayListEnabled(tenantId, peopleSettingsInput.getBirthdayListEnabled());
    }
}

