/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.harisekhon;

import com.linkedin.harisekhon.Utils;

public class Timeout
implements Runnable {
    private int secs;

    public Timeout(int secs) {
        if (secs == 0) {
            throw new IllegalArgumentException("Timeout(secs) cannot be zero!");
        }
        this.secs = secs;
    }

    @Override
    public void run() {
        this.timeout(this.secs);
    }

    private void timeout(long secs) {
        try {
            Thread.sleep(1000L * secs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Utils.quit("UNKNOWN", String.format("self timed out after %s sec%s", secs, Utils.plural(secs)));
    }

    public static void main(String[] args) {
        int secs = 10;
        if (args.length > 0) {
            secs = Integer.valueOf(args[0]);
        }
        new Thread(new Timeout(secs)).start();
    }
}

