/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import de.justsoftware.people.application.SearchApplicationService;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.search.solr.model.SearchModel;
import de.justsoftware.people.model.PagedResult;
import de.justsoftware.people.model.TenantId;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/search"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rH\u0017JH\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\u0010\b\u0001\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/people/controller/SearchController;", "", "searchApplicationService", "Lde/justsoftware/people/application/SearchApplicationService;", "(Lde/justsoftware/people/application/SearchApplicationService;)V", "search", "Lde/justsoftware/people/model/PagedResult;", "Lde/justsoftware/people/business/search/solr/model/SearchModel;", "authCtx", "Lde/justsoftware/people/authorization/AuthorizationContext;", "query", "", "offset", "", "limit", "searchForNames", "types", "", "people-api"})
public class SearchController {
    @NotNull
    private final SearchApplicationService searchApplicationService;

    public SearchController(@NotNull SearchApplicationService searchApplicationService) {
        Intrinsics.checkNotNullParameter((Object)searchApplicationService, (String)"searchApplicationService");
        this.searchApplicationService = searchApplicationService;
    }

    @GetMapping
    @NotNull
    public PagedResult<SearchModel> search(@NotNull AuthorizationContext authCtx, @RequestParam(value="query", required=false) @Nullable String query, @RequestParam(value="offset") int offset, @RequestParam(value="limit") int limit) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        String string = query;
        if (string == null) {
            string = "";
        }
        return this.searchApplicationService.allProfilesAndUserGroups(authCtx, tenantId, string, offset, limit);
    }

    @GetMapping(value={"/names"})
    @NotNull
    public PagedResult<SearchModel> searchForNames(@NotNull AuthorizationContext authCtx, @RequestParam(value="query", required=false) @Nullable String query, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit, @RequestParam(value="type", required=false) @Nullable Set<String> types) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        String string = query;
        if (string == null) {
            string = "";
        }
        if ((set = types) == null) {
            set = SetsKt.emptySet();
        }
        return this.searchApplicationService.searchInNames(authCtx, tenantId, string, set, offset, limit);
    }
}

