/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.monitoring;

import de.justsoftware.notificationservice.business.InternalPeopleService;
import de.justsoftware.notificationservice.business.UserGroupMemberService;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/notificationservice/monitoring/UserGroupMembershipChecksumHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "internalPeopleService", "Lde/justsoftware/notificationservice/business/InternalPeopleService;", "userGroupMemberService", "Lde/justsoftware/notificationservice/business/UserGroupMemberService;", "(Lde/justsoftware/notificationservice/business/InternalPeopleService;Lde/justsoftware/notificationservice/business/UserGroupMemberService;)V", "lastChecksum", "", "lastChecksumDate", "Ljava/time/Instant;", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "isChecksumUnchangedSince", "", "checksum", "duration", "Ljava/time/temporal/TemporalAmount;", "notification-service"})
public final class UserGroupMembershipChecksumHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final InternalPeopleService internalPeopleService;
    @NotNull
    private final UserGroupMemberService userGroupMemberService;
    @Nullable
    private String lastChecksum;
    @Nullable
    private Instant lastChecksumDate;

    public UserGroupMembershipChecksumHealthIndicator(@NotNull InternalPeopleService internalPeopleService, @NotNull UserGroupMemberService userGroupMemberService) {
        Intrinsics.checkNotNullParameter((Object)internalPeopleService, (String)"internalPeopleService");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberService, (String)"userGroupMemberService");
        super("User Group Membership checksum synchronized health check failed");
        this.internalPeopleService = internalPeopleService;
        this.userGroupMemberService = userGroupMemberService;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String ownChecksum = this.userGroupMemberService.getUserGroupMembershipChecksum();
        if (((CharSequence)ownChecksum).length() == 0) {
            builder.withDetail("Skipped", (Object)"Skip User Group Membership checksum synchronized check since unsupported dbms.");
            builder.status(Status.UP);
        } else {
            String peopleChecksum = this.internalPeopleService.getUserGroupMembershipChecksum();
            if (((CharSequence)peopleChecksum).length() == 0) {
                builder.withDetail("Skipped", (Object)"Failed to retrieve checksum from people. Maybe people service is down. Please check people health indicator.");
                builder.status(Status.UP);
                return;
            }
            if (Intrinsics.areEqual((Object)peopleChecksum, (Object)ownChecksum)) {
                builder.withDetail("Synchronized", (Object)("Checksum " + ownChecksum + " matches the checksum in people"));
                builder.status(Status.UP);
            } else {
                Duration duration = Duration.ofMinutes(5L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
                if (this.isChecksumUnchangedSince(ownChecksum, (TemporalAmount)duration)) {
                    builder.withDetail("Not Synchronized", (Object)("Checksum " + ownChecksum + " does not match the checksum in people " + peopleChecksum + " and has not changed since 5 minutes"));
                    builder.status(Status.DOWN);
                } else {
                    builder.withDetail("Not Synchronized", (Object)("Checksum " + ownChecksum + " does not match the checksum in people " + peopleChecksum + " but synchronization still in progress"));
                    builder.status(Status.UP);
                }
            }
            this.lastChecksum = ownChecksum;
        }
    }

    private final boolean isChecksumUnchangedSince(String checksum, TemporalAmount duration) {
        Instant now = Instant.now();
        boolean isUnchangedSinceDuration = this.lastChecksumDate != null && this.lastChecksum != null && Intrinsics.areEqual((Object)checksum, (Object)this.lastChecksum) && now.minus(duration).isAfter(this.lastChecksumDate);
        this.lastChecksumDate = now;
        return isUnchangedSinceDuration;
    }
}

