/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationservice.business.MobilePushNotificationService;
import de.justsoftware.notificationservice.kafka.NotificationKafkaConsumer;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import de.justsoftware.notificationservice.persistence.UserGroupMemberRepository;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.DbNotification;
import de.justsoftware.notificationservice.persistence.model.DbUserGroupMember;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.persistence.model.UserGroupId;
import de.justsoftware.notificationservice.util.KafkaUtilsKt;
import jakarta.validation.ValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0017J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0010H\u0017J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0013\u001a\u00020\u0010H\u0013J\u001e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0012J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0012J\u001e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0012J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/notificationservice/kafka/NotificationKafkaConsumer;", "", "mobilePushNotificationService", "Lde/justsoftware/notificationservice/business/MobilePushNotificationService;", "notificationRepository", "Lde/justsoftware/notificationservice/persistence/NotificationRepository;", "userGroupMemberRepository", "Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;", "deliveryStatusRepository", "Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;", "(Lde/justsoftware/notificationservice/business/MobilePushNotificationService;Lde/justsoftware/notificationservice/persistence/NotificationRepository;Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;)V", "listen", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "Lde/justsoftware/notificationclient/model/Notification;", "process", "key", "notification", "resolveReceivers", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "saveDeliveryStatus", "dbNotification", "Lde/justsoftware/notificationservice/persistence/model/DbNotification;", "resolvedReceivers", "saveNotification", "", "sendMobilePush", "resolveToProfileIds", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nNotificationKafkaConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationKafkaConsumer.kt\nde/justsoftware/notificationservice/kafka/NotificationKafkaConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n766#2:171\n857#2,2:172\n1549#2:174\n1620#2,3:175\n766#2:178\n857#2,2:179\n1549#2:181\n1620#2,3:182\n1360#2:185\n1446#2,5:186\n1549#2:191\n1620#2,3:192\n1549#2:195\n1620#2,3:196\n1855#2,2:199\n*S KotlinDebug\n*F\n+ 1 NotificationKafkaConsumer.kt\nde/justsoftware/notificationservice/kafka/NotificationKafkaConsumer\n*L\n138#1:171\n138#1:172,2\n139#1:174\n139#1:175,3\n141#1:178\n141#1:179,2\n142#1:181\n142#1:182,3\n143#1:185\n143#1:186,5\n144#1:191\n144#1:192,3\n152#1:195\n152#1:196,3\n156#1:199,2\n*E\n"})
public class NotificationKafkaConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobilePushNotificationService mobilePushNotificationService;
    @NotNull
    private final NotificationRepository notificationRepository;
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final DeliveryStatusRepository deliveryStatusRepository;
    private static final Logger LOG = LoggerFactory.getLogger(NotificationKafkaConsumer.class);

    public NotificationKafkaConsumer(@NotNull MobilePushNotificationService mobilePushNotificationService, @NotNull NotificationRepository notificationRepository, @NotNull UserGroupMemberRepository userGroupMemberRepository, @NotNull DeliveryStatusRepository deliveryStatusRepository) {
        Intrinsics.checkNotNullParameter((Object)mobilePushNotificationService, (String)"mobilePushNotificationService");
        Intrinsics.checkNotNullParameter((Object)notificationRepository, (String)"notificationRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter((Object)deliveryStatusRepository, (String)"deliveryStatusRepository");
        this.mobilePushNotificationService = mobilePushNotificationService;
        this.notificationRepository = notificationRepository;
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.deliveryStatusRepository = deliveryStatusRepository;
    }

    @KafkaListener(id="notificationConsumer", containerFactory="notificationListenerContainerFactory", topics={"just.notification.dispatch"})
    public void listen(@NotNull ConsumerRecords<String, Notification> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        for (ConsumerRecord record : KafkaUtilsKt.filterAndLogDeserializationErrors(records)) {
            try {
                Object object = record.key();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key(...)");
                String string = (String)object;
                Object object2 = record.value();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value(...)");
                this.process(string, (Notification)object2);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to process Notification record with {} = {}", record.key(), record.value());
            }
        }
    }

    @VisibleForTesting
    public void process(@NotNull String key, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        long start = System.currentTimeMillis();
        LOG.debug("Process notification with key {}: {}", (Object)key, (Object)notification);
        if (this.notificationRepository.existsById((Object)notification.getId())) {
            LOG.warn("Notification with id: {} already exists. Notification will be skipped.", (Object)notification.getId());
            return;
        }
        Set resolvedReceivers = this.resolveReceivers(notification);
        if (resolvedReceivers.isEmpty()) {
            LOG.debug("Skip notification {} as there are no receivers, e.g. an empty user group is the sole receiver", (Object)notification.getId());
            return;
        }
        boolean notificationSaved = this.saveNotification(notification, resolvedReceivers);
        if (!notificationSaved) {
            return;
        }
        if (Intrinsics.areEqual((Object)notification.isWithoutPush(), (Object)true)) {
            LOG.debug("Skip sending push for notification {}", (Object)notification.getId());
            LOG.info("Processing notification with key {} took {} ms", (Object)key, (Object)(System.currentTimeMillis() - start));
            return;
        }
        this.sendMobilePush(notification, resolvedReceivers);
        LOG.info("Processing notification with key {} took {} ms", (Object)key, (Object)(System.currentTimeMillis() - start));
    }

    private boolean saveNotification(Notification notification, Set<? extends ProfileId> resolvedReceivers) {
        DbNotification dbNotification;
        DbNotification dbNotification2 = new DbNotification(notification.getId(), notification.getTenantId(), notification.getAppId(), notification.getDefaultTitle(), notification.getDefaultText(), notification.getType(), notification.getTimestamp());
        dbNotification2.setLocalizedTitle((Map)notification.getLocalizedTitle());
        dbNotification2.setLocalizedText((Map)notification.getLocalizedText());
        dbNotification2.setDefaultSecondaryText(notification.getDefaultSecondaryText());
        dbNotification2.setLocalizedSecondaryText((Map)notification.getLocalizedSecondaryText());
        dbNotification2.setMailAuthorName(notification.getMailAuthorName());
        dbNotification2.setDefaultMailContainerName(notification.getDefaultMailContainerName());
        dbNotification2.setLocalizedMailContainerName((Map)notification.getLocalizedMailContainerName());
        dbNotification2.setDefaultMailReplacementText(notification.getDefaultMailReplacementText());
        dbNotification2.setLocalizedMailReplacementText((Map)notification.getLocalizedMailReplacementText());
        dbNotification2.setTargetId(notification.getTargetId());
        dbNotification2.setPayload(notification.getPayload());
        try {
            dbNotification = (DbNotification)this.notificationRepository.saveAndFlush((Object)dbNotification2);
        }
        catch (ValidationException e) {
            LOG.warn("Failed to save Notification with id: " + notification.getId() + ". Notification will be skipped. Root cause is: {}", (Object)e.getMessage());
            return false;
        }
        catch (DataIntegrityViolationException e) {
            LOG.warn("Failed to save Notification with id: " + notification.getId() + ". Notification will be skipped. Root cause is: {}", (Object)e.getMessage());
            return false;
        }
        DbNotification dbNotification3 = dbNotification;
        Intrinsics.checkNotNull((Object)dbNotification3);
        DbNotification savedNotification = dbNotification3;
        try {
            this.saveDeliveryStatus(savedNotification, resolvedReceivers);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to save DeliveryStatus for notification " + notification.getId(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Nonnull
    private Set<ProfileId> resolveReceivers(Notification notification) {
        ImmutableSet immutableSet = notification.getReceivers();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"getReceivers(...)");
        Set receivers = this.resolveToProfileIds((Set)immutableSet);
        ImmutableSet immutableSet2 = notification.getExcludedReceivers();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet2, (String)"getExcludedReceivers(...)");
        Set excludedReceivers = this.resolveToProfileIds((Set)immutableSet2);
        return SetsKt.minus((Set)receivers, (Iterable)excludedReceivers);
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> resolveToProfileIds(Set<String> $this$resolveToProfileIds) {
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        String receiver;
        Iterable $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2 = $this$resolveToProfileIds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            receiver = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)receiver, (String)"PROFILE,", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void idString;
            receiver = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId((String)idString));
        }
        List directReceivers = (List)destination$iv$iv;
        Iterable $i$f$map22 = $this$resolveToProfileIds;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String receiver2 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)receiver2, (String)"USER_GROUP,", (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void groupIdString;
            String receiver2 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new UserGroupId((String)groupIdString).getId());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            UUID groupId = (UUID)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.userGroupMemberRepository.findAllByGroupId(groupId);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void groupMember;
            DbUserGroupMember list$iv$iv = (DbUserGroupMember)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Long l = groupMember.getProfileId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getProfileId(...)");
            collection.add(new ProfileId(((Number)l).longValue()));
        }
        List groupReceivers = (List)destination$iv$iv2;
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)directReceivers, (Iterable)groupReceivers));
    }

    /*
     * WARNING - void declaration
     */
    private void saveDeliveryStatus(DbNotification dbNotification, Set<? extends ProfileId> resolvedReceivers) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = resolvedReceivers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void receiverId;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DbDeliveryStatus(dbNotification.getId(), receiverId.toString(), NotificationStatus.OPEN));
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        DeliveryStatusRepository deliveryStatusRepository = this.deliveryStatusRepository;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean bl = false;
            deliveryStatusRepository.saveAllAndFlush(p0);
        }
    }

    private void sendMobilePush(Notification notification, Set<? extends ProfileId> resolvedReceivers) {
        try {
            this.mobilePushNotificationService.sendPushNotifications(notification, resolvedReceivers);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to send mobile push notifications.", (Throwable)e);
        }
    }
}

