/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search.update;

import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.search.SolrService;
import de.justsoftware.wikiservice.search.update.UpdateSearchIndexConsumer;
import de.justsoftware.wikiservice.util.KafkaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0017J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexConsumer;", "", "solrService", "Lde/justsoftware/wikiservice/search/SolrService;", "(Lde/justsoftware/wikiservice/search/SolrService;)V", "onUpdateSearchIndex", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "toSupportedAbstractId", "Lde/justsoftware/wikiservice/model/AbstractId;", "id", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nUpdateSearchIndexConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateSearchIndexConsumer.kt\nde/justsoftware/wikiservice/search/update/UpdateSearchIndexConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,69:1\n1603#2,9:70\n1855#2:79\n1856#2:81\n1612#2:82\n1#3:80\n37#4,2:83\n*S KotlinDebug\n*F\n+ 1 UpdateSearchIndexConsumer.kt\nde/justsoftware/wikiservice/search/update/UpdateSearchIndexConsumer\n*L\n33#1:70,9\n33#1:79\n33#1:81\n33#1:82\n33#1:80\n44#1:83,2\n*E\n"})
public class UpdateSearchIndexConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolrService solrService;
    private static final Logger LOG = LoggerFactory.getLogger(UpdateSearchIndexConsumer.class);

    @Autowired
    public UpdateSearchIndexConsumer(@NotNull SolrService solrService) {
        Intrinsics.checkNotNullParameter((Object)solrService, (String)"solrService");
        this.solrService = solrService;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="searchUpdateIndexConsumer", containerFactory="searchUpdateIndexConsumerFactory", topics={"just.wiki-service.search.updateIndex"}, idIsGroup=false)
    public void onUpdateSearchIndex(@NotNull ConsumerRecords<String, String> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
            SolrService solrService = this.solrService;
            boolean $i$f$mapNotNull = false;
            void var4_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AbstractId it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ConsumerRecord it = (ConsumerRecord)element$iv$iv;
                boolean bl2 = false;
                Object object = it.value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
                if (this.toSupportedAbstractId((String)object) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            solrService.index((List)destination$iv$iv);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private AbstractId toSupportedAbstractId(String id) {
        String[] stringArray = new String[]{","};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)id, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length != 2) {
            return null;
        }
        try {
            stringArray = (String[])(switch (WhenMappings.$EnumSwitchMapping$0[IdType.valueOf((String)parts[0]).ordinal()]) {
                case 1 -> new ChapterId(id);
                case 2 -> new WikiId(id);
                case 3 -> new ArticleId(id);
                default -> null;
            });
        }
        catch (RuntimeException e) {
            LOG.error("Failed to convert '" + id + "' to valid AbstractId. Skip this record.", (Throwable)e);
            stringArray = null;
        }
        return stringArray;
    }
}

