/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.WikiApplicationService;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.generated.MutationCreateWikiArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationDeleteWikiArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationUpdateWikiArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryWikiArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryWikisArgs;
import de.justsoftware.wikiservice.model.WikiId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00150\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/WikiFetcher;", "", "wikiApplicationService", "Lde/justsoftware/wikiservice/application/WikiApplicationService;", "(Lde/justsoftware/wikiservice/application/WikiApplicationService;)V", "byArticleId", "Lgraphql/schema/DataFetcher;", "Lde/justsoftware/wikiservice/business/model/WikiDto;", "getByArticleId", "()Lgraphql/schema/DataFetcher;", "byChapterId", "getByChapterId", "byId", "getById", "create", "getCreate", "delete", "getDelete", "update", "getUpdate", "wikis", "", "getWikis", "wiki-service"})
public class WikiFetcher {
    @NotNull
    private final WikiApplicationService wikiApplicationService;
    @NotNull
    private final DataFetcher<WikiDto> byId;
    @NotNull
    private final DataFetcher<List<WikiDto>> wikis;
    @NotNull
    private final DataFetcher<WikiDto> byArticleId;
    @NotNull
    private final DataFetcher<WikiDto> byChapterId;
    @NotNull
    private final DataFetcher<WikiDto> create;
    @NotNull
    private final DataFetcher<WikiDto> update;
    @NotNull
    private final DataFetcher<WikiDto> delete;

    @Autowired
    public WikiFetcher(@NotNull WikiApplicationService wikiApplicationService) {
        Intrinsics.checkNotNullParameter((Object)wikiApplicationService, (String)"wikiApplicationService");
        this.wikiApplicationService = wikiApplicationService;
        this.byId = arg_0 -> WikiFetcher.byId$lambda$0(this, arg_0);
        this.wikis = arg_0 -> WikiFetcher.wikis$lambda$1(this, arg_0);
        this.byArticleId = arg_0 -> WikiFetcher.byArticleId$lambda$2(this, arg_0);
        this.byChapterId = arg_0 -> WikiFetcher.byChapterId$lambda$3(this, arg_0);
        this.create = arg_0 -> WikiFetcher.create$lambda$4(this, arg_0);
        this.update = arg_0 -> WikiFetcher.update$lambda$5(this, arg_0);
        this.delete = arg_0 -> WikiFetcher.delete$lambda$6(this, arg_0);
    }

    @NotNull
    public DataFetcher<WikiDto> getById() {
        return this.byId;
    }

    @NotNull
    public DataFetcher<List<WikiDto>> getWikis() {
        return this.wikis;
    }

    @NotNull
    public DataFetcher<WikiDto> getByArticleId() {
        return this.byArticleId;
    }

    @NotNull
    public DataFetcher<WikiDto> getByChapterId() {
        return this.byChapterId;
    }

    @NotNull
    public DataFetcher<WikiDto> getCreate() {
        return this.create;
    }

    @NotNull
    public DataFetcher<WikiDto> getUpdate() {
        return this.update;
    }

    @NotNull
    public DataFetcher<WikiDto> getDelete() {
        return this.delete;
    }

    private static final WikiDto byId$lambda$0(WikiFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        QueryWikiArgs args = new QueryWikiArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.wikiApplicationService.read(args.getId(), context.getAuthContext());
    }

    private static final List wikis$lambda$1(WikiFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        QueryWikisArgs args = new QueryWikisArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.wikiApplicationService.getWikis(args.getOnlySubscribedWikis(), args.getPage(), args.getSize(), context.getAuthContext());
    }

    private static final WikiDto byArticleId$lambda$2(WikiFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        WikiId wikiId = ((ArticleDto)env.getSource()).getWikiId();
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.wikiApplicationService.read(wikiId, context.getAuthContext());
    }

    private static final WikiDto byChapterId$lambda$3(WikiFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        WikiId wikiId = ((ChapterDto)env.getSource()).getWikiId();
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.wikiApplicationService.read(wikiId, context.getAuthContext());
    }

    private static final WikiDto create$lambda$4(WikiFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationCreateWikiArgs args = new MutationCreateWikiArgs(map);
        return this$0.wikiApplicationService.create(args.getWiki(), context.getAuthContext());
    }

    private static final WikiDto update$lambda$5(WikiFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationUpdateWikiArgs args = new MutationUpdateWikiArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.wikiApplicationService.update(args.getId(), args.getWiki(), context.getAuthContext());
    }

    private static final WikiDto delete$lambda$6(WikiFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationDeleteWikiArgs args = new MutationDeleteWikiArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.wikiApplicationService.delete(args.getId(), context.getAuthContext());
    }
}

