/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.server;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.survey.presentation.shared.SurveyController;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.DBSurveyParticipantAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.QuestionSaveResult;
import de.justsoftware.onx.survey.shared.model.SurveyDetails;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyResult;
import de.justsoftware.onx.survey.shared.model.SurveyTeaser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SurveyControllerImpl
implements SurveyController {
    @Autowired
    private SurveyService _surveyService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;

    public SurveyDetails deleteSurveyParticipantAnswers(SurveyId surveyId) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._surveyService.deleteSurveyParticipantAnswers(surveyId, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this.getSurveyDetailsById(surveyId);
    }

    public SurveyTeaser saveSurveyParticipantAnswers(SurveyId surveyId, List<DBSurveyParticipantAnswer> answers) {
        DBSurvey survey = this._surveyService.getBySurveyId(surveyId);
        if (survey == null) {
            throw new ServiceException("Survey does not exists");
        }
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._surveyService.saveSurveyParticipantAnswers(surveyId, answers, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this._surveyService.getSurveyTeaser(survey, (AuthorizationCheckContextWithUserId)authorizationContext);
    }

    public void deleteSurvey(SurveyId surveyId) {
        DBSurvey survey = this._surveyService.getBySurveyId(surveyId);
        if (survey == null) {
            throw new InvalidIdServiceException();
        }
        AuthorizationContext authContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._surveyService.deleteSurvey(surveyId, (AuthorizationCheckContextWithUserId)authContext);
    }

    public SurveyResult getSurveyResultById(SurveyId surveyId) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        auth.check((ItemId)surveyId, (Action)StaticAction.SURVEY_READ);
        auth.check((ItemId)surveyId, (Action)StaticAction.SURVEY_READ_RESULT);
        return this._surveyService.getSurveyResultById(surveyId);
    }

    public SurveyId insertSurveyBaseData(DBSurvey survey) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        auth.check((ItemId)survey.getParentId(), (Action)StaticAction.SURVEY_CREATE);
        return this._surveyService.insertSurveyBaseData(auth.getUserId(), survey);
    }

    public DBSurvey getRemoteBySurveyId(SurveyId id) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        auth.check((ItemId)id, (Action)StaticAction.SURVEY_READ);
        return this._surveyService.getBySurveyId(id);
    }

    public void updateSurveyBaseData(DBSurvey survey) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        auth.check((ItemId)survey.getId(), (Action)StaticAction.SURVEY_UPDATE);
        this._surveyService.updateSurveyBaseData(survey);
    }

    public QuestionSaveResult saveQuestions(SurveyId id, List<DBSurveyQuestion> questions, boolean forceSave) {
        AuthorizationContext authContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._surveyService.saveQuestions(id, questions, forceSave, (AuthorizationCheckContextWithUserId)authContext);
    }

    public SurveyDetails getSurveyDetailsById(SurveyId surveyId) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)surveyId, (Action)StaticAction.SURVEY_READ);
        return this._surveyService.getSurveyDetailsById(surveyId, (AuthorizationCheckContextWithUserId)authorizationContext);
    }

    public ListAndCount<SurveyTeaser> getSurveyTeasersByParentId(GlobalId parentId, int offset, int limit) {
        return this._surveyService.getSurveyTeasersByParentId(parentId, offset, limit, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public boolean mayCreateSurvey(EntityId entityId) {
        return this._authorizationContextProvider.getAuthorizationContextForCurrentUser().may((ItemId)entityId, (Action)StaticAction.SURVEY_CREATE);
    }

    public SurveyId getRedirectSurveyOnNewMembership(EntityId entityId) {
        return this._surveyService.getRedirectSurveyOnNewMembership(entityId, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }
}

