/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui.views;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyDetailsHandler;
import de.justsoftware.onx.survey.presentation.client.ui.views.SurveyTeaserView;
import de.justsoftware.onx.survey.shared.i18n.SurveyMessages;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SurveyTeaserViewImpl
extends Composite
implements SurveyTeaserView {
    private static final SurveyMessages I18N_SURVEY_MSG = I18nMediator.SURVEY_MSG;
    final FlowPanel _container = new FlowPanel();
    final FlowPanel _titleRow = new FlowPanel();
    final FlowPanel _authorRow = new FlowPanel();
    final FlowPanel _participationRow = new FlowPanel();
    final InlineLabel _notPublishedLabel = new InlineLabel(" (" + I18nMediator.SURVEY.surveyNotPublished() + ")");
    private final DateFormatter _dateFormatter;

    public SurveyTeaserViewImpl(DateFormatter dateFormatter) {
        this._dateFormatter = dateFormatter;
        this._container.addStyleName("search-result-badge");
        this._container.addStyleName("survey-teaser");
        this._titleRow.addStyleName("survey-teaser-title");
        this._authorRow.addStyleName("survey-teaser-author");
        this._participationRow.addStyleName("survey-teaser-participation");
        this._container.add((Widget)this._titleRow);
        this._container.add((Widget)this._authorRow);
        this._container.add((Widget)this._participationRow);
        this.initWidget((Widget)this._container);
    }

    public void setTitle(String title, SurveyId surveyId) {
        this._titleRow.clear();
        this._titleRow.add((Widget)new Hyperlink(title, SurveyDetailsHandler.token((SurveyId)surveyId, (boolean)false)));
        this._titleRow.add((Widget)this._notPublishedLabel);
    }

    public void setOwnerAndCreateDate(String name, PersonTeaserModel owner, Date createDate) {
        this._authorRow.clear();
        String i18nText = I18N_SURVEY_MSG.createdByWithDateAndTime(WidgetUtil.getWrappedKey((int)0), this._dateFormatter.formatDate(createDate), this._dateFormatter.formatTime(createDate));
        WidgetUtil.i18nLinkedText((String)i18nText, (HasWidgets.ForIsWidget)this._authorRow, (IsWidget[])new IsWidget[]{PersonUtil.profileLink((String)name, (PersonTeaserModel)owner)});
    }

    public void setParticipationStatus(String status) {
        this._participationRow.clear();
        this._participationRow.add((Widget)new Label(status));
    }

    public void setNotPublished(boolean notPublished) {
        this._notPublishedLabel.setVisible(notPublished);
    }
}

