/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.upload;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.freiheit.toro.server.upload.AbstractImageUploadServlet;
import com.freiheit.toro.server.upload.CKEditorUploadResult;
import com.freiheit.toro.server.upload.UploadResult;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.server.upload.AlbumImageUploadHelper;
import de.justsoftware.onx.server.upload.UploadedImageInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@ParametersAreNonnullByDefault
public class CopyNPasteImageUploadServlet
extends AbstractImageUploadServlet {
    private final AlbumImageUploadHelper _albumImageUploadHelper;
    private final AlbumService _albumService;

    @Autowired
    @ParametersAreNonnullByDefault
    public CopyNPasteImageUploadServlet(Settings settings, StorageServerHelper storageServerHelper, SessionAuthorizationContextProvider authorizationContextProvider, @Qualifier(value="acceptableImageUploadTypes") Set<String> types, AlbumImageUploadHelper albumImageUploadHelper, I18nService i18nService, AlbumService albumService) {
        super(settings, storageServerHelper, authorizationContextProvider, i18nService, types);
        this._albumImageUploadHelper = albumImageUploadHelper;
        this._albumService = albumService;
    }

    @RequestMapping(value={"/ckeditor/upload"})
    public ModelAndView handleRequest(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException {
        return super.handleRequest(request, response);
    }

    protected UploadResult saves(List<MultipartFile> files, AuthorizationCheckContextWithUserId authCtx, HashMap<String, String> parameters) {
        try {
            String sParentId = parameters.get("parentId");
            String sParentType = parameters.get("parentType");
            if (sParentId == null || sParentType == null) {
                return CKEditorUploadResult.error((String)"Fail! Parent ID provided is not valid.");
            }
            GlobalId parentId = GlobalId.create((long)Long.parseLong(sParentId), (ItemType)ItemType.valueOf((String)sParentType));
            AlbumId albumId = this._albumService.getNoModuleDBAlbumByParentId(parentId).getId();
            ImmutableList infos = this._albumImageUploadHelper.saveImagesToAlbum(files, authCtx, albumId, false);
            if (infos.size() != 1) {
                return CKEditorUploadResult.error((String)String.format("Only one image is supported, got %d", infos.size()));
            }
            UploadedImageInfo info = (UploadedImageInfo)infos.get(0);
            return CKEditorUploadResult.success((String)info.getFilename(), (String)ImageUrlUtil.getFullAlbumImageUrl((ImageSize)ImageSize.ORIGINAL, (String)info.getFilename()));
        }
        catch (PermissionDeniedException e) {
            return CKEditorUploadResult.error((String)((BasicConstants)this._i18nService.createProxy(BasicConstants.class, authCtx.getLocale())).noPermission());
        }
        catch (InvalidIDException e) {
            return CKEditorUploadResult.error((String)"Fail! Parent ID provided is not valid.");
        }
    }

    protected UploadResult returnError(HttpServletRequest request, String message) {
        return CKEditorUploadResult.error((String)message);
    }
}

