/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.FieldNameResolver;
import de.justsoftware.onx.common.presentation.client.ui.EntityMemberRoleNameFunction;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Optionals;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.container.presentation.client.ui.ReactProfileComponent;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.person.presentation.client.ProfileFieldNameTranslator;
import de.justsoftware.onx.person.presentation.client.ui.PersonRoleUtil;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.BaseSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultBadgeView;
import de.justsoftware.onx.searchnew.shared.model.PersonSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.PersonSearchResultEntityMemberInformation;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersonSearchResultBadgePresenter
extends BaseSearchResultBadgePresenter {
    public PersonSearchResultBadgePresenter(@Nonnull ClientFactory clientFactory, @Nonnull PersonSearchResultBadgeModel model, boolean displayPublicationDate, boolean displayEntityMemberInfo, boolean displayParents, boolean displayContextSwitch, @Nullable SearchTrackingInfo searchTrackingInfo, @Nullable String additionalOverlayStyleName) {
        super(clientFactory, displayContextSwitch, (SearchableId)model.getId(), searchTrackingInfo, additionalOverlayStyleName);
        Widget profileLink = PersonUtil.profileLink((PersonTeaserModel)model, (ClientFactory)clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITHOUT_POPUP);
        this._view.setTitleWidget(profileLink, profileLink);
        this.setImage(model);
        this.setLastChangeDate(model.getModifyDate());
        this.addPublicationDate(displayPublicationDate, model.getPublicationDate());
        ImmutableSet roleNames = model.getRoleNames();
        if (!CollectionUtil.isEmpty((Iterable)roleNames)) {
            PersonRoleUtil.RoleNamesAndTitle roleNamesAndTitle = PersonRoleUtil.getRoles((Set)ImmutableSet.copyOf((Collection)roleNames));
            this._view.addDetails(roleNamesAndTitle.getTitle(), roleNamesAndTitle.getRoleNames());
        }
        PersonSearchResultEntityMemberInformation entityMemberInfo = model.getEntityMemberInformation();
        if (displayEntityMemberInfo && entityMemberInfo != null) {
            this._view.addDetails(I18nMediator.PROFILE.entityMemberRoles(), Joiner.on((String)", ").skipNulls().join((Iterable)FluentIterable.from((Iterable)entityMemberInfo.getEntityMemberRoles()).transform((Function)new EntityMemberRoleNameFunction(entityMemberInfo.getEntityType())).transform(Optionals.orNullFunction())));
        }
        this._view.addDetails((Collection)ProfileFieldNameTranslator.INSTANCE.translateValues((Iterable)model.getVisibleFields()), (FieldNameResolver)ProfileFieldNameTranslator.INSTANCE);
        this._view.addFoundIn((Collection)model.getFoundInFields(), (FieldNameResolver)ProfileFieldNameTranslator.INSTANCE);
        this._view.setParentEnabled(displayParents);
    }

    private void setImage(@Nonnull PersonSearchResultBadgeModel model) {
        AnchorPanel ap = new AnchorPanel();
        Image icon = new Image(ImageUrlUtil.getFullSmallUserImageUrl((String)model.getLogo()));
        icon.addStyleName("userimage");
        icon.setTitle(I18nMediator.BASIC_CONSTANTS.profile());
        ap.add((Widget)icon);
        ap.setTargetHistoryToken(ReactProfileComponent.token((PersonId)model.getId()));
        this._view.setIconWidget((Widget)ap);
    }

    public SearchResultBadgeView getView() {
        return this._view;
    }
}

