/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.raweditor.presentation.server;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.AntiSamyService;
import de.justsoftware.onx.common.shared.model.SaveCKResult;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.raweditor.business.RawEditorService;
import de.justsoftware.onx.raweditor.presentation.shared.RawEditorController;
import de.justsoftware.onx.raweditor.presentation.shared.RawInsertVersionResult;
import de.justsoftware.onx.raweditor.shared.model.RawEditorId;
import de.justsoftware.onx.raweditor.shared.model.db.DBRawEditorVersion;
import de.justsoftware.onx.raweditor.shared.server.model.RawEditorItem;
import java.util.Set;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RawEditorControllerImpl
implements RawEditorController {
    private static final Logger LOG = LoggerFactory.getLogger(RawEditorControllerImpl.class);
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private RawEditorService _rawEditorService;
    @Autowired
    private AntiSamyService _antiSamyService;

    public RawInsertVersionResult insertVersion(RawEditorId id, String newText) {
        CleanResults cleanResults;
        DBRawEditorVersion rawEditorVersion = (DBRawEditorVersion)InvalidIdServiceException.check((Object)((DBRawEditorVersion)this._rawEditorService.getCurrentVersionsByIds((Set)ImmutableSet.of((Object)id)).get((Object)id)));
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        auth.check((Item)new RawEditorItem(rawEditorVersion), (Action)StaticAction.RAWEDITOR_WRITE);
        try {
            cleanResults = this._antiSamyService.scan(newText);
        }
        catch (ScanException e) {
            LOG.error("", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (PolicyException e) {
            LOG.error("", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        rawEditorVersion.setText(cleanResults.getCleanHTML());
        this._rawEditorService.insertVersion(rawEditorVersion);
        return new RawInsertVersionResult(rawEditorVersion.getText(), new SaveCKResult(cleanResults.getNumberOfErrors() > 0));
    }
}

