/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.presentation.client.presenter;

import com.freiheit.toro.client.event.EventListener;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.presentation.client.events.LikeStatusChangedEvent;
import de.justsoftware.onx.like.presentation.client.presenter.LikersPopupPresenter;
import de.justsoftware.onx.like.presentation.client.ui.LikeClientFactory;
import de.justsoftware.onx.like.presentation.client.ui.LikeView;
import de.justsoftware.onx.like.shared.model.LikeStatus;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class LikePresenter
implements LikeView.Presenter {
    private ItemId _id = null;
    private LikeStatus _likeStatus = null;
    private final LikeView _view;
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final EventManager _eventManager;
    private final ClientFactory _clientFactory;

    public LikePresenter(ClientFactory clientFactory, LikeView view) {
        this._clientFactory = clientFactory;
        this._eventManager = clientFactory.eventManager();
        this._eventManagerHelper = new EventManager.EventManagerHelper(this._eventManager);
        this._view = view;
        this._view.setPresenter((LikeView.Presenter)this);
    }

    public void setId(@Nullable ItemId id) {
        this._id = id;
        this._likeStatus = null;
        if (id == null) {
            this.updateView(LikeStatus.EMPTY);
        } else {
            this._clientFactory.likeClientFactory().getClientService().getLike(this._id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateView(@Nullable LikeStatus status) {
        this._likeStatus = status;
        this._view.setLikeStatus(this._likeStatus);
    }

    public void onLikeToggle() {
        if (this._likeStatus != null && this._likeStatus.mayLikeOrUnlike()) {
            this._view.showWaitIcon();
            this._clientFactory.likeClientFactory().getClientService().setLikeAndSubscription(this._id, !this._likeStatus.isDoILike());
        }
    }

    public void toggleLikersPopup(Widget popupPos) {
        if (this._id != null) {
            LikersPopupPresenter.getInstance((LikeClientFactory)this._clientFactory.likeClientFactory()).toggleLikersPopup(this._id, popupPos);
        }
    }

    public void onLoad() {
        this._eventManagerHelper.registerListener(LikeStatusChangedEvent.class, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onUnload() {
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
    }
}

