/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.server;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.impl.ServerDateFormatter;
import de.justsoftware.onx.common.presentation.shared.util.PageTitleUtil;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.EntityDetailsService;
import de.justsoftware.onx.container.business.EntityMembershipInfoService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.presentation.server.EntityPrintPreviewController;
import de.justsoftware.onx.container.presentation.server.model.EntityPrintPreviewEditor;
import de.justsoftware.onx.container.presentation.server.model.EntityPrintPreviewEntityAttribute;
import de.justsoftware.onx.container.presentation.server.model.EntityPrintPreviewInfo;
import de.justsoftware.onx.container.presentation.server.model.EntityPrintPreviewLabels;
import de.justsoftware.onx.container.presentation.server.model.EntityPrintPreviewLink;
import de.justsoftware.onx.container.presentation.server.model.EntityPrintPreviewMultiWiki;
import de.justsoftware.onx.container.presentation.server.model.EntityPrintPreviewVersion;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDetailsNotVisibleException;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityDynamicAttributeClientModel;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMembership;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.IEntityDynamicAttribute;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ReleaseProcessStatus;
import de.justsoftware.onx.container.shared.model.RoleOrInheritedRole;
import de.justsoftware.onx.design.shared.model.StaticWebResource;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiClientModel;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonRolesClientTranslation;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.raweditor.shared.i18n.RawEditorConstants;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersion;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersion;
import de.justsoftware.web.design.WebResourceHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/printPreview"})
@ParametersAreNonnullByDefault
public class EntityPrintPreviewController {
    private static final Logger LOG = LoggerFactory.getLogger(EntityPrintPreviewController.class);
    private static final String COMMA_SEP = ", ";
    private static final String COMMA_NEWLINE_SEP = ",\n";
    private final Settings _settings;
    private final EntityService _entityService;
    private final EntityDetailsService _entityDetailsService;
    private final EntityConfigService _entityConfigService;
    private final PersonService _personService;
    private final ProfileTeaserService _profileTeaserService;
    private final MultiWikiService _multiWikiService;
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final I18nService _i18nService;
    private final WebResourceHandler _webResourceHandler;
    private final InternalLinkService _internalLinkService;
    private final EntityMembershipInfoService _entityMembershipInfoService;

    @Autowired
    public EntityPrintPreviewController(Settings settings, EntityService entityService, EntityDetailsService entityDetailsService, EntityConfigService entityConfigService, PersonService personService, ProfileTeaserService profileTeaserService, MultiWikiService multiWikiService, SessionAuthorizationContextProvider authorizationContextProvider, I18nService i18nService, WebResourceHandler webResourceHandler, InternalLinkService internalLinkService, EntityMembershipInfoService entityMembershipInfoService) {
        this._settings = settings;
        this._entityService = entityService;
        this._entityDetailsService = entityDetailsService;
        this._entityConfigService = entityConfigService;
        this._personService = personService;
        this._profileTeaserService = profileTeaserService;
        this._multiWikiService = multiWikiService;
        this._authorizationContextProvider = authorizationContextProvider;
        this._i18nService = i18nService;
        this._webResourceHandler = webResourceHandler;
        this._internalLinkService = internalLinkService;
        this._entityMembershipInfoService = entityMembershipInfoService;
    }

    @RequestMapping(value={"/{entityId}"}, produces={"text/html"})
    @Nonnull
    public ModelAndView showPrintPreview(@PathVariable(value="entityId") String entityId, @RequestParam(value="locale", required=false) @Nullable String locale, @RequestParam(value="viewAsRole", required=false) @Nullable String viewAsRole, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationContext authContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser(request);
        return new ModelAndView("entity_print_preview", this.createModel(entityId, authContext, locale, viewAsRole, request, response));
    }

    @Nonnull
    @VisibleForTesting
    public Map<String, Object> createModel(String entityIdString, AuthorizationContext authContext, @Nullable String locale, @Nullable String viewAsRole, HttpServletRequest request, HttpServletResponse response) {
        String jsResource;
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("favIconUrl", this._settings.getFavIconUrl());
        model.put("favIconImageType", this._settings.getFavIconImageType());
        model.put("basePath", "/toro/resource/html");
        ImmutableMap resources = this._webResourceHandler.getCurrentResourceNames((Iterable)ImmutableSet.of((Object)StaticWebResource.ENTITY_PRINT_PREVIEW_CSS, (Object)StaticWebResource.ENTITY_PRINT_PREVIEW_JS), request, response);
        String styleResource = (String)resources.get((Object)StaticWebResource.ENTITY_PRINT_PREVIEW_CSS);
        if (styleResource != null) {
            model.put("styleResource", styleResource);
        }
        if ((jsResource = (String)resources.get((Object)StaticWebResource.ENTITY_PRINT_PREVIEW_JS)) != null) {
            model.put("jsResource", jsResource);
        }
        ServerLocalizedMessages messages = this._i18nService.getLocalizedMessages(StringUtil.defaultIfBlank((String)locale, (String)authContext.getLocale()));
        try {
            EntityId entityId = EntityId.parse((String)entityIdString);
            EntityDetails entityDetails = this._entityDetailsService.getDetailsById(entityId, authContext);
            model.put("labels", new EntityPrintPreviewLabels(messages, entityDetails.getType()));
            model.put("title", this.getPageTitle(entityDetails, messages, authContext, request));
            model.put("info", this.getInfoModel(entityDetails, messages, authContext));
            model.put("multiWiki", this.getMultiWikiModel(entityDetails, viewAsRole, messages, authContext));
            model.put("wiki", this.getWikiModel(entityDetails, messages));
            model.put("infoWidget", this.getInfoWidgetModel(entityDetails, messages));
            model.put("rawEditors", this.getRawEditors(entityDetails, messages));
        }
        catch (InvalidIdServiceException | EntityDetailsNotVisibleException e) {
            LOG.error("Error during print preview", e);
            model.put("title", messages.entityPrintPreviewMessages().errorPageTitle());
            model.put("errorMessage", messages.entityPrintPreviewMessages().errorEntityDoesNotExistOrIsNotVisibleMessage());
        }
        catch (RuntimeException e) {
            LOG.error("Error during print preview", (Throwable)e);
            model.put("title", messages.entityPrintPreviewMessages().errorPageTitle());
            model.put("errorMessage", messages.entityPrintPreviewMessages().errorGenericMessage());
        }
        return model;
    }

    @Nonnull
    private ImmutableList<EntityPrintPreviewEditor> getRawEditors(EntityDetails entityDetails, ServerLocalizedMessages messages) {
        ImmutableList.Builder editorsBuilder = ImmutableList.builder();
        RawEditorConstants rawEditorConstants = messages.rawEditorConstants();
        this.addRawEditor(editorsBuilder, entityDetails, (ComponentType)StaticComponentType.RAW_EDITOR1, rawEditorConstants.rawEditor1());
        this.addRawEditor(editorsBuilder, entityDetails, (ComponentType)StaticComponentType.RAW_EDITOR2, rawEditorConstants.rawEditor2());
        this.addRawEditor(editorsBuilder, entityDetails, (ComponentType)StaticComponentType.RAW_EDITOR3, rawEditorConstants.rawEditor3());
        this.addRawEditor(editorsBuilder, entityDetails, (ComponentType)StaticComponentType.RAW_EDITOR4, rawEditorConstants.rawEditor4());
        return editorsBuilder.build();
    }

    private void addRawEditor(ImmutableList.Builder<EntityPrintPreviewEditor> editorsBuilder, EntityDetails entityDetails, ComponentType componentType, String title) {
        ComponentModel component = (ComponentModel)entityDetails.getComponents().get((Object)componentType);
        if (component == null) {
            return;
        }
        RawEditorVersion editor = (RawEditorVersion)component.getModuleData();
        if (editor == null) {
            return;
        }
        editorsBuilder.add((Object)new EntityPrintPreviewEditor(title, editor.getText()));
    }

    @CheckForNull
    private EntityPrintPreviewEditor getInfoWidgetModel(EntityDetails entityDetails, ServerLocalizedMessages messages) {
        if (!entityDetails.getComponents().containsKey((Object)StaticComponentType.INFO_WIDGET)) {
            return null;
        }
        return new EntityPrintPreviewEditor(messages.entityConstants(entityDetails.getType()).infoWidgetComponent(), entityDetails.getDescription());
    }

    @CheckForNull
    private EntityPrintPreviewMultiWiki getMultiWikiModel(EntityDetails entityDetails, @Nullable String viewAsRole, ServerLocalizedMessages messages, AuthorizationContext authContext) throws ServiceException {
        String viewedAs;
        MultiWikiClientModel clientModel = this.getMultiWikiClientModel(entityDetails, viewAsRole, authContext);
        if (clientModel == null) {
            return null;
        }
        PersonRolesClientTranslation rolesTranslation = this._personService.getRolesTranslation(messages.getLocale());
        boolean allRolesAreForced = Iterables.all((Iterable)clientModel.getRolesForSectionRead(), (Predicate)AuthorityModel.IS_FORCED);
        ImmutableList sections = FluentIterable.from((Iterable)clientModel.getSections()).transform((Function)new /* Unavailable Anonymous Inner Class!! */).filter(Predicates.notNull()).toList();
        if (!clientModel.getRolesForViewAs().isEmpty()) {
            String viewedAsRole = clientModel.getViewedAsRole();
            viewedAs = messages.multiWikiMessages().youAreViewingThisContensAs() + " " + (viewedAsRole != null ? rolesTranslation.getDisplayName(viewedAsRole) : messages.multiWikiMessages().myself());
        } else {
            viewedAs = null;
        }
        return new EntityPrintPreviewMultiWiki(viewedAs, sections);
    }

    @CheckForNull
    private MultiWikiClientModel getMultiWikiClientModel(EntityDetails entityDetails, @Nullable String viewAsRole, AuthorizationContext authContext) throws ServiceException {
        ComponentModel component = (ComponentModel)entityDetails.getComponents().get((Object)StaticComponentType.MULTI_WIKI);
        if (component == null) {
            return null;
        }
        MultiWikiClientModel defaultClientModel = (MultiWikiClientModel)component.getModuleData();
        if (defaultClientModel == null || defaultClientModel.getSections().isEmpty()) {
            return null;
        }
        if (Objects.equals(defaultClientModel.getViewedAsRole(), viewAsRole)) {
            return defaultClientModel;
        }
        try {
            return this._multiWikiService.getCurrentWiki(defaultClientModel.getId(), viewAsRole, (AuthorizationCheckContextWithUserId)authContext);
        }
        catch (InvalidIDException e) {
            LOG.warn("Error loading multi wiki", (Throwable)e);
            return null;
        }
    }

    @CheckForNull
    private EntityPrintPreviewEditor getWikiModel(EntityDetails entityDetails, ServerLocalizedMessages messages) {
        ComponentModel component = (ComponentModel)entityDetails.getComponents().get((Object)StaticComponentType.WIKI_EDITOR);
        if (component == null) {
            return null;
        }
        String title = messages.wikiEditorConstants().wikiEditor();
        WikiEditor wikiEditor = (WikiEditor)component.getModuleData();
        if (wikiEditor == null) {
            return new EntityPrintPreviewEditor(title, "");
        }
        WikiVersion version = wikiEditor.getCurrentVersion();
        if (version.getVersion() == 0) {
            return new EntityPrintPreviewEditor(title, version.getText());
        }
        String versionAuthorString = this.getFullnameWithDefault(version.getAuthor(), messages.wikiEditorConstants().unknownAuthor(), false, messages);
        String versionInfo = messages.entityPrintPreviewMessages().wikiVersion(version.getVersion(), versionAuthorString);
        return new EntityPrintPreviewEditor(title + " (" + versionInfo + ")", version.getText());
    }

    @Nonnull
    private EntityPrintPreviewInfo getInfoModel(EntityDetails entityDetails, ServerLocalizedMessages messages, AuthorizationContext authContext) {
        EntityPrintPreviewVersion version = this.getVersionModel(entityDetails, messages);
        String duration = this._entityConfigService.getDurationTimeOption(entityDetails.getType()) == EntityDurationTimeOption.OFF ? null : this._entityService.getLocalizedDurationString(entityDetails.getDBEntity(), messages.getLocale());
        String tags = this.getTags(entityDetails);
        ImmutableList assignedEntities = this.getAssignedEntities(entityDetails, messages);
        ImmutableListMultimap allAdmins = this._entityMembershipInfoService.getAllEntityAdmins(entityDetails.getId(), (AuthorizationCheckContextWithLocale)authContext);
        ImmutableList attributes = this.getAttributes(entityDetails, messages, authContext);
        return new EntityPrintPreviewInfo(entityDetails.getName(), this._internalLinkService.getEntityUrl(entityDetails.getId(), InternalLinkService.LinkType.URL), duration, entityDetails.getLocation(), tags, assignedEntities, this.getAdminsOrNull((RoleOrInheritedRole)EntityMemberRole.ADMIN, allAdmins, messages), this.getAdminsOrNull((RoleOrInheritedRole)EntityMemberRole.CO_ADMIN, allAdmins, messages), this.getAdminsOrNull((RoleOrInheritedRole)InheritsRole.INHERIT_ADMINS, allAdmins, messages), version, attributes);
    }

    @CheckForNull
    private ImmutableList<EntityPrintPreviewLink> getAdminsOrNull(RoleOrInheritedRole role, ImmutableListMultimap<RoleOrInheritedRole, EntityMembership> allAdmins, ServerLocalizedMessages messages) {
        ImmutableList result = FluentIterable.from((Iterable)allAdmins.get((Object)role)).transform((Function)new EntityMembershipToProfileLinkTransformer(this._internalLinkService, this.getPersonTeaserToFullnameFn(messages, true))).filter(Predicates.notNull()).toList();
        return !result.isEmpty() ? result : null;
    }

    @CheckForNull
    private ImmutableList<EntityPrintPreviewEntityAttribute> getAttributes(EntityDetails entityDetails, ServerLocalizedMessages messages, AuthorizationContext authContext) {
        ImmutableList attributeValues = entityDetails.getDBEntity().getDynamicAttributes();
        ImmutableList attributeConfigs = this._entityConfigService.getDynamicAttributesForType(entityDetails.getType());
        if (attributeValues.isEmpty() || attributeConfigs.isEmpty()) {
            return null;
        }
        ImmutableMap attributeValuesMap = Maps.uniqueIndex((Iterable)attributeValues, (Function)IEntityDynamicAttribute.TO_ATTRIBUTE_ID);
        ImmutableList.Builder attributeBuilder = ImmutableList.builder();
        for (DynamicAttributeConfig attributeConfig : attributeConfigs) {
            EntityDynamicAttributeClientModel attributeValue = (EntityDynamicAttributeClientModel)attributeValuesMap.get((Object)attributeConfig.getId());
            if (attributeValue == null) continue;
            EntityPrintPreviewEntityAttribute attributeModel = this.getAttributeValue(attributeConfig, attributeValue, entityDetails.getType(), messages, authContext);
            attributeBuilder.add((Object)attributeModel);
        }
        return attributeBuilder.build();
    }

    @Nonnull
    private EntityPrintPreviewEntityAttribute getAttributeValue(DynamicAttributeConfig attributeConfig, EntityDynamicAttributeClientModel attributeValue, EntityType entityType, ServerLocalizedMessages messages, AuthorizationContext authContext) {
        DynamicEntityAttributesMessages dynamicEntityAttributesMessages = this._i18nService.getEntityAttributeMessages(entityType, attributeValue.getAttributeId(), messages.getLocale());
        String label = dynamicEntityAttributesMessages.name(attributeValue.getAttributeId());
        String value = (String)attributeConfig.getInput().accept((Input.InputVisitor)new /* Unavailable Anonymous Inner Class!! */);
        return new EntityPrintPreviewEntityAttribute(label, value);
    }

    @CheckForNull
    private String getTags(EntityDetails entityDetails) {
        String tags = entityDetails.getTags();
        if (StringUtil.isBlank((String)tags) || !this._entityConfigService.tagsEnabled(entityDetails.getType())) {
            return null;
        }
        return Joiner.on((String)COMMA_SEP).join((Object[])tags.split("\\s*,\\s*"));
    }

    @CheckForNull
    private ImmutableList<EntityPrintPreviewLink> getAssignedEntities(EntityDetails entityDetails, ServerLocalizedMessages messages) {
        ImmutableList linkedEntities = entityDetails.getLinkedEntities();
        if (linkedEntities == null || linkedEntities.isEmpty()) {
            return null;
        }
        return FluentIterable.from((Iterable)linkedEntities).transform((Function)new /* Unavailable Anonymous Inner Class!! */).filter(Predicates.notNull()).toList();
    }

    @CheckForNull
    private EntityPrintPreviewVersion getVersionModel(EntityDetails entityDetails, ServerLocalizedMessages messages) {
        EntityVersionClientModel version = entityDetails.getVersion();
        if (version == null || !this._entityConfigService.releaseProcessMandatory(entityDetails.getType())) {
            return null;
        }
        String versionType = this.getVersionTypeString(version.getVersionType(), messages);
        boolean isDeclined = ReleaseProcessStatus.DECLINED.getName().equals(version.getStatus().getName());
        String releaseDate = this.formatDateTime((Date)version.getReleaseDate(), messages);
        String expirationDate = this.formatDateTime((Date)version.getExpirationDate(), messages);
        return new EntityPrintPreviewVersion(versionType, version.getVersionString(), releaseDate, expirationDate, isDeclined);
    }

    @CheckForNull
    private String formatDateTime(@Nullable Date date, ServerLocalizedMessages messages) {
        if (date == null) {
            return null;
        }
        return new ServerDateFormatter(messages, null).formatDateTime(date);
    }

    @Nonnull
    private String getFullname(PersonTeaserModel person, boolean showSecretName, ServerLocalizedMessages messages) {
        if (person.isDeleted()) {
            return messages.profileConstants().deletedUser();
        }
        if (!person.isVisible() && !showSecretName) {
            return messages.basicConstants().secretItem();
        }
        DBPerson dbPerson = this._personService.getPersonById((PersonId)person.getId());
        return this._personService.getAnnotatedNameWithLocale(dbPerson, messages.getLocale());
    }

    @Nonnull
    private Function<PersonTeaserModel, String> getPersonTeaserToFullnameFn(ServerLocalizedMessages messages, boolean showSecretName) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    private String getFullnameWithDefault(@Nullable PersonTeaserModel person, String defaultName, boolean showSecretName, ServerLocalizedMessages messages) {
        return person != null ? this.getFullname(person, showSecretName, messages) : defaultName;
    }

    @Nonnull
    private String getVersionTypeString(EntityVersionType entityVersionType, ServerLocalizedMessages messages) {
        switch (5.$SwitchMap$de$justsoftware$onx$container$shared$model$EntityVersionType[entityVersionType.ordinal()]) {
            case 1: {
                return messages.entityVersionConstants().draftVersion();
            }
            case 2: {
                return messages.entityVersionConstants().majorVersion();
            }
            case 3: {
                return messages.entityVersionConstants().minorVerson();
            }
        }
        return "";
    }

    @Nonnull
    private String getPageTitle(EntityDetails entity, ServerLocalizedMessages messages, AuthorizationContext authContext, HttpServletRequest request) {
        EntityType entityType = entity.getType();
        String translatedEntityType = messages.entityConstants(entityType).entity(entityType);
        String entityPageTitle = messages.entityMessages(entityType).entityPageTitle(entity.getName(), translatedEntityType);
        return PageTitleUtil.appendPageTitleSuffix((String)(messages.entityPrintPreviewMessages().pageTitlePrefix() + " " + entityPageTitle), (String)this._settings.getDefaultSiteTitle());
    }
}

