/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.Controls;
import com.github.gwtbootstrap.client.ui.FormLabel;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.TimestampBox;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.presentation.client.ui.EntityReleaseReviewerStatusWidget;
import de.justsoftware.onx.container.presentation.client.ui.ReviewsViewImpl;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.person.presentation.client.ui.ReviewsView;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserWithEntityVersionReviewStatusModel;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReviewsViewImpl
extends Composite
implements ReviewsView {
    private static final ReviewsViewUIBinder UI_BINDER = (ReviewsViewUIBinder)GWT.create(ReviewsViewUIBinder.class);
    private static final EntityVersionConstants I18N_ENTITY_VERSION_CONSTANTS = I18nMediator.ENTITY_VERSION_CONSTANTS;
    private static final String STYLE_BOOTSTRAP_ERROR = "error";
    @UiField
    WidgetStyle _style;
    @UiField
    Label _reviewsViewHeader;
    @UiField
    FlowPanel _reviewsViewBody;
    @UiField
    FlowPanel _reviewsViewActions;
    private final FlowPanel _actionsControls = new FlowPanel();
    private final ControlGroup _releaseDateCG = new ControlGroup();
    private final HelpInline _releaseDateHelp = new HelpInline();
    private final ReleaseDateComponent _releaseDateComponent;
    private final ControlGroup _expirationDateCG = new ControlGroup();
    private final TimestampBox _expirationDate = new TimestampBox();
    private final HelpInline _expirationDateHelp = new HelpInline();
    private final ControlGroup _declineMessageCG = new ControlGroup();
    private final TextBox _declineMessageWidget = new TextBox();
    private final HelpInline _declineMessageWidgetHelp = new HelpInline();
    private final ReviewsView.Presenter _presenter;
    private final DateFormatter _dateFormatter;

    public ReviewsViewImpl(@Nonnull ReviewsView.Presenter presenter, @Nonnull DateFormatter dateFormatter) {
        this._presenter = presenter;
        this._dateFormatter = dateFormatter;
        this._releaseDateComponent = new ReleaseDateComponent(this._presenter);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this.clearPopupContent();
    }

    private void setReviewsViewActionsPanel() {
        this._reviewsViewActions.add((Widget)this._actionsControls);
    }

    private void addToReviewsViewBody(@Nonnull String label, @Nonnull Widget widget) {
        this.addToReviewsViewBody(new ControlGroup(), label, (IsWidget)widget, null);
    }

    private void addToReviewsViewBody(@Nonnull ControlGroup controlGroup, @Nonnull String label, @Nonnull IsWidget widget, @Nullable HelpInline help) {
        FormLabel controlLabel = new FormLabel();
        controlLabel.getElement().setInnerText(label);
        controlLabel.addStyleName("control-label");
        Controls controls = new Controls();
        controls.add(widget);
        if (help != null) {
            controls.add((Widget)help);
            help.addStyleName(this._style.reviewHelp());
        }
        controlGroup.add((Widget)controlLabel);
        controlGroup.add((Widget)controls);
        controlGroup.addStyleName(this._style.reviewControlGroup());
        this._reviewsViewBody.add((Widget)controlGroup);
    }

    private void addToReviewsViewActions(@Nonnull Widget widget) {
        this._actionsControls.add(widget);
    }

    public void setHeader(String headerLabel) {
        this._reviewsViewHeader.setText(headerLabel);
    }

    public void addInviter(PersonTeaserModel inviter) {
        FormLabel widget = new FormLabel();
        widget.addStyleName(this._style.reviewTextBox());
        widget.add(PersonUtil.profileLink((PersonTeaserModel)inviter, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        this.addToReviewsViewBody(I18N_ENTITY_VERSION_CONSTANTS.inviter(), (Widget)widget);
    }

    public void addEntity(EntityInfo toReview) {
        FormLabel widget = new FormLabel();
        widget.addStyleName(this._style.reviewTextBox());
        widget.add(EntityUtils.createEntityNameLinkOrLabel((EntityInfo)toReview, (EntityUtils.EntityLinkOptions)EntityUtils.EntityLinkOptions.create((ClickHandler)new /* Unavailable Anonymous Inner Class!! */)));
        this.addToReviewsViewBody(I18N_ENTITY_VERSION_CONSTANTS.toReview(), (Widget)widget);
    }

    public void addReviewersRow(EntityVersionReviewData reviewData) {
        int reviewerCount = 0;
        for (PersonTeaserWithEntityVersionReviewStatusModel reviewer : reviewData.getReviewer()) {
            this._reviewsViewBody.add((Widget)new EntityReleaseReviewerStatusWidget(this._presenter, ++reviewerCount, reviewer));
        }
    }

    public void addReleaseDate(DateWithoutTimezone releaseDate, boolean editable) {
        if (releaseDate == null) {
            this._releaseDateComponent.setChangeable(false);
        } else {
            this._releaseDateComponent.setChangeable(true);
            this._releaseDateComponent.setDate((Date)releaseDate);
        }
        if (editable) {
            this.addToReviewsViewBody(this._releaseDateCG, I18N_ENTITY_VERSION_CONSTANTS.releaseDate(), this._releaseDateComponent.getView(), this._releaseDateHelp);
        } else {
            FormLabel widget = new FormLabel();
            if (releaseDate != null) {
                widget.getElement().setInnerText(this._dateFormatter.formatDateTime((Date)this._releaseDateComponent.getDate()));
            } else {
                widget.getElement().setInnerText(this._releaseDateComponent.getFixedText());
            }
            widget.addStyleName(this._style.reviewTextBox());
            this.addToReviewsViewBody(I18N_ENTITY_VERSION_CONSTANTS.releaseDate(), (Widget)widget);
        }
    }

    public void addExpirationDate(DateWithoutTimezone expirationDate, boolean editable) {
        if (editable) {
            this._expirationDate.setValue((Object)expirationDate);
            this._expirationDate.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.addToReviewsViewBody(this._expirationDateCG, I18N_ENTITY_VERSION_CONSTANTS.expirationDate(), (IsWidget)this._expirationDate, this._expirationDateHelp);
        } else {
            FormLabel widget = new FormLabel();
            if (expirationDate != null) {
                widget.getElement().setInnerText(this._dateFormatter.formatDateTime((Date)expirationDate));
            } else {
                widget.getElement().setInnerText(I18N_ENTITY_VERSION_CONSTANTS.noExpirationDate());
            }
            widget.addStyleName(this._style.reviewTextBox());
            this.addToReviewsViewBody(I18N_ENTITY_VERSION_CONSTANTS.expirationDate(), (Widget)widget);
        }
    }

    public void addChangeMessage(String changeMessage) {
        FormLabel widget = new FormLabel();
        widget.getElement().setInnerText(changeMessage);
        widget.addStyleName(this._style.reviewTextBox());
        this.addToReviewsViewBody(I18N_ENTITY_VERSION_CONSTANTS.changeMessage(), (Widget)widget);
    }

    public void addCommentForReviewers(String commentForReviewers) {
        FormLabel widget = new FormLabel();
        widget.getElement().setInnerText(commentForReviewers);
        widget.addStyleName(this._style.reviewTextBox());
        this.addToReviewsViewBody(I18N_ENTITY_VERSION_CONSTANTS.commentForReviewer(), (Widget)widget);
    }

    public void activateAcceptAction() {
        JCButton widget = new JCButton();
        widget.setText(I18N_ENTITY_VERSION_CONSTANTS.accept());
        widget.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addToReviewsViewActions((Widget)widget);
    }

    public void activateDeclineAction() {
        Anchor widget = new Anchor();
        widget.addStyleName(this._style.reviewActionSpace());
        widget.setText(I18N_ENTITY_VERSION_CONSTANTS.decline());
        widget.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addToReviewsViewActions((Widget)widget);
    }

    public void activateOpenEntityTypeAction(String buttonLabel) {
        JCButton widget = new JCButton();
        widget.setText(buttonLabel);
        widget.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addToReviewsViewActions((Widget)widget);
    }

    public void activateRemoveMessageAction() {
        Anchor widget = new Anchor();
        widget.addStyleName(this._style.reviewActionSpace());
        widget.setText(I18N_ENTITY_VERSION_CONSTANTS.removeMessage());
        widget.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addToReviewsViewActions((Widget)widget);
    }

    public void clearPopupContent() {
        this.clearValidationErrors();
        this._reviewsViewHeader.setText("");
        this._releaseDateCG.clear();
        this._declineMessageCG.clear();
        this._expirationDateCG.clear();
        this._reviewsViewBody.clear();
        this._reviewsViewActions.clear();
        this._actionsControls.clear();
        this.setReviewsViewActionsPanel();
    }

    public void setDeclineMessage(String text, boolean editable) {
        if (editable) {
            this._declineMessageWidget.setText(text);
            this._declineMessageWidget.setReadOnly(!editable);
            this._declineMessageWidget.addStyleName(this._style.reviewTextBox());
            this._declineMessageWidget.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.addToReviewsViewBody(this._declineMessageCG, I18N_ENTITY_VERSION_CONSTANTS.declineMessage(), (IsWidget)this._declineMessageWidget, this._declineMessageWidgetHelp);
        } else {
            FormLabel widget = new FormLabel();
            widget.getElement().setInnerText(text);
            widget.addStyleName(this._style.reviewTextBox());
            this.addToReviewsViewBody(I18N_ENTITY_VERSION_CONSTANTS.declineMessage(), (Widget)widget);
        }
    }

    public void activateCloseAction() {
        Anchor widget = new Anchor();
        widget.addStyleName(this._style.reviewActionSpace());
        widget.setText(I18N_ENTITY_VERSION_CONSTANTS.closePopup());
        widget.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addToReviewsViewActions((Widget)widget);
    }

    public void clearValidationErrors() {
        this.showValidationError((Panel)this._releaseDateCG, this._releaseDateHelp, "", "");
        this.showValidationError((Panel)this._expirationDateCG, this._expirationDateHelp, "", "");
        this.showValidationError((Panel)this._declineMessageCG, this._declineMessageWidgetHelp, "", "");
    }

    public void showDeclineMessageValidationError(@Nullable String value) {
        this.showValidationError((Panel)this._declineMessageCG, this._declineMessageWidgetHelp, value);
    }

    public void showExpirationDateValidationError(@Nullable String value) {
        this.showValidationError((Panel)this._expirationDateCG, this._expirationDateHelp, value);
    }

    public void showReleaseDateValidationError(@Nullable String value) {
        this.showValidationError((Panel)this._releaseDateCG, this._releaseDateHelp, value);
    }

    private void showValidationError(@Nonnull Panel group, @Nonnull HelpInline inlineHelp, @Nullable String value) {
        this.showValidationError(group, inlineHelp, value, "");
    }

    private void showValidationError(@Nonnull Panel group, @Nonnull HelpInline inlineHelp, @Nullable String value, @Nullable String title) {
        boolean hasError = ClientStringUtil.hasText((String)value);
        inlineHelp.setVisible(hasError);
        if (hasError) {
            group.addStyleName(STYLE_BOOTSTRAP_ERROR);
        } else {
            group.removeStyleName(STYLE_BOOTSTRAP_ERROR);
        }
        inlineHelp.setText(ClientStringUtil.nullToEmpty((String)value));
        inlineHelp.setTitle(ClientStringUtil.nullToEmpty((String)title));
    }
}

