/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.event.EventListener;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.dom.client.Element;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.i18n.dynamic.client.LocaleInfo;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.ui.EntityPrintPreviewAnchor;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.multiwiki.presentation.client.MultiWikiRoleSelectedEvent;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityPrintPreviewAnchor
extends Composite {
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final SimplePanel _container;
    private final JCIconOnlyAnchor _iconAnchor;
    private final Anchor _anchor;
    private EntityId _entityId;
    private String _viewAsRole;

    public EntityPrintPreviewAnchor(EntityId entityId, EventManager eventManager, ViewMode viewMode, @Nullable String classnames) {
        this._entityId = entityId;
        this._viewAsRole = null;
        this._eventManagerHelper = new EventManager.EventManagerHelper(eventManager);
        this._container = new SimplePanel();
        this._iconAnchor = new JCIconOnlyAnchor();
        this._anchor = new Anchor();
        this._container.addStyleName("just-breadcrumb-icon");
        Roles.getNavigationRole().set((Element)this._container.getElement());
        this.initAnchors(classnames);
        this.setViewMode(viewMode);
        this.initWidget((Widget)this._container);
    }

    public void setViewMode(ViewMode viewMode) {
        this._container.clear();
        if (viewMode == ViewMode.ICON) {
            this._container.add((Widget)this._iconAnchor);
        } else {
            this._container.add((Widget)this._anchor);
        }
    }

    private void initAnchors(@Nullable String classnames) {
        String text = I18nMediator.BASIC_CONSTANTS.openPrintPreview();
        String target = "_blank";
        this._iconAnchor.setIcon(IconType.PRINT);
        this._iconAnchor.setTarget("_blank");
        this._iconAnchor.setTitle(text);
        this._anchor.setTarget("_blank");
        this._anchor.setText(text);
        this._anchor.setTitle(text);
        if (!StringUtil.isBlank((String)classnames)) {
            this._iconAnchor.addStyleName(classnames);
            this._anchor.addStyleName(classnames);
        }
        this.updateIconAnchorHref();
    }

    private void updateIconAnchorHref() {
        EntityId currentLayoutEntityId;
        String params = "?locale=" + LocaleInfo.getCurrentLocaleName();
        if (this._viewAsRole != null) {
            params = params + "&viewAsRole=" + URL.encodeQueryString((String)this._viewAsRole);
        }
        if ((currentLayoutEntityId = EntityMediator.getInstance().getCurrentLayoutEntityId()) != null) {
            params = params + "&layoutId=" + currentLayoutEntityId.asString();
        }
        String url = "/toro/printPreview/" + this._entityId.asString() + params;
        this._iconAnchor.setHref(url);
        this._anchor.setHref(url);
    }

    public void setEntityId(EntityId entityId) {
        this._entityId = entityId;
        this._viewAsRole = null;
        this.updateIconAnchorHref();
    }

    protected void onLoad() {
        super.onLoad();
        this._eventManagerHelper.registerListener(MultiWikiRoleSelectedEvent.class, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onUnload() {
        super.onUnload();
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
    }
}

