/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.model.DeactivatableDialogBoxType;
import com.github.gwtbootstrap.client.ui.NavWidget;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.AbstractActionCommand;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.ui.EntityMemberActionCommand;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.PublicEntityMember;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum EntityMemberActionCommand {
    MAKE_ADMIN/* Unavailable Anonymous Inner Class!! */,
    MAKE_COADMIN/* Unavailable Anonymous Inner Class!! */,
    DELETE_COADMIN/* Unavailable Anonymous Inner Class!! */,
    REVOKE_MEMBERSHIP/* Unavailable Anonymous Inner Class!! */,
    ASSIGN_MEMBERSHIP/* Unavailable Anonymous Inner Class!! */,
    MOVE_TO_EVENT_PARTICIPANT_LIST/* Unavailable Anonymous Inner Class!! */,
    MOVE_TO_EVENT_WAITINGLIST/* Unavailable Anonymous Inner Class!! */,
    MOVE_TO_EVENT_UNDECIDED_LIST/* Unavailable Anonymous Inner Class!! */,
    MOVE_TO_EVENT_NOT_ATTENDING_LIST/* Unavailable Anonymous Inner Class!! */,
    REMOVE_FROM_EVENT/* Unavailable Anonymous Inner Class!! */;

    private final DeactivatableDialogBoxType _deactivatableDialogBoxType;

    private EntityMemberActionCommand(DeactivatableDialogBoxType deactivatableDialogBoxType) {
        this._deactivatableDialogBoxType = deactivatableDialogBoxType;
    }

    @CheckForNull
    private static String getConfirmTextIfAdmin(PublicEntityMember dataObject, EntityType type) {
        if (EntityMemberRoles.isAdmin((Set)dataObject.getRoles())) {
            return I18nMediator.getEntityMessagesByEntityType((EntityType)type).attentionYouWillBecomeAdmin(type);
        }
        return null;
    }

    @Nonnull
    public AbstractActionCommand<PublicEntityMember, Void> makeSingleActionCommand(PublicEntityMember member, EntityType type, EntityId entityId) {
        JCIconOnlyAnchor icon = new JCIconOnlyAnchor();
        icon.setTitle(this.getCommandName(type));
        icon.setIconSize(IconSize.LARGE);
        return new EntityMemberActionCommandWidget((Widget)icon, this, member, type, entityId);
    }

    @Nonnull
    public AbstractActionCommand<PublicEntityMember, Void> makeActionCommand(PublicEntityMember member, EntityType type, EntityId entityId) {
        NavWidget navWidget = new NavWidget();
        navWidget.setText(this.getCommandName(type));
        navWidget.setTitle(this.getCommandName(type));
        return new EntityMemberActionCommandWidget((Widget)navWidget, this, member, type, entityId);
    }

    @Nonnull
    public AbstractActionCommand<ImmutableSet<PersonId>, Void> makeActionCommand(ImmutableSet<PersonId> members, EntityType type, EntityId entityId) {
        NavWidget navWidget = new NavWidget();
        navWidget.setText(this.getCommandName(type));
        navWidget.setTitle(this.getCommandName(type));
        return new EntityMemberBatchActionCommandWidget((Widget)navWidget, this, members, entityId, type);
    }

    abstract void doCommand(ImmutableSet<PersonId> var1, EntityId var2, EntityType var3, AsyncCallback<Void> var4);

    @CheckForNull
    abstract String getConfirmText(PublicEntityMember var1, EntityType var2);

    @Nonnull
    abstract String getCommandName(EntityType var1);
}

