/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.github.gwtbootstrap.client.ui.Icon;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.design.client.util.CssClassUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityIconCreator {
    public static final EntityIconCreator DEFAULT = new EntityIconCreator(ImageSize.ICON_SMALL);
    private final ImageSize _imageSize;

    public EntityIconCreator(ImageSize imageSize) {
        this._imageSize = imageSize;
    }

    @Nonnull
    public Widget createDefaultIcon(CoreApp app, EntityType type) {
        ClientEntityConfig config = HostPropertiesMediator.getClientEntityConfig((EntityType)type);
        SimplePanel iconPanel = new SimplePanel();
        iconPanel.addStyleName("entity-placeholder-icon");
        iconPanel.addStyleName(CssClassUtil.getAppColorClass((CoreApp)app));
        iconPanel.addStyleName(CssClassUtil.getStyleForEntityType((EntityType)type));
        iconPanel.addStyleName(CssClassUtil.getWellFormedCssClass((String)this._imageSize.toString()));
        iconPanel.add((Widget)new Icon(config.getIcon()));
        return iconPanel;
    }

    @Nonnull
    public Widget create(EntityInfo entity) {
        return this.create(entity.getApp(), (EntityType)entity.getType(), entity.getIcon());
    }

    @Nonnull
    private Widget create(CoreApp app, EntityType type, @Nullable String icon) {
        if (!StringUtil.isBlank((String)icon)) {
            return new Image(ImageUrlUtil.getFullEntityImageUrl((EntityType)type, (ImageSize)this._imageSize, (String)icon));
        }
        return this.createDefaultIcon(app, type);
    }
}

