/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter;

import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.components.InfoWidgetComponentEditorPresenter;
import de.justsoftware.onx.common.presentation.client.ui.components.InfoWidgetComponentPresenter;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.TabNameForConfiguration;
import de.justsoftware.onx.container.presentation.client.presenter.InformationTabPresenter;
import de.justsoftware.onx.container.presentation.client.ui.EntityBaseDataWidgetBuilder;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityInformationAdminData;
import de.justsoftware.onx.container.presentation.client.ui.InformationTabView;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InformationTabPresenter {
    private final InformationTabView _view;

    public InformationTabPresenter(ClientFactory clientFactory, EntityDetails entityDetails) {
        EntityType entityType = entityDetails.getType();
        CoreApp entityApp = entityDetails.getApp();
        ImmutableSet may = entityDetails.getMay();
        EntityId id = entityDetails.getId();
        EventManager.EventManagerHelper eventManagerHelper = new EventManager.EventManagerHelper(clientFactory.eventManager());
        EntityConstants entityConstants = clientFactory.entityFactory().entityConstants(entityType);
        ClientEntityConfig config = clientFactory.entityFactory().entityConfig(entityType);
        this._view = clientFactory.entityTabClientFactory().createInformationTabView(entityConstants);
        EntityInformationAdminData.Presenter adminPresenter = clientFactory.entityTabClientFactory().createEntityAdminPresenter(id);
        EntityBaseDataWidgetBuilder widgetBuilder = new EntityBaseDataWidgetBuilder(clientFactory, entityConstants, entityDetails, this._view.getBaseDataContainer()).addDurationRow().addClosingDateRow().addLocationRow().addEntityTypeRow().addAssignedEntitiesRow().addAdmins(adminPresenter).addCoAdmins(adminPresenter).addInheritedCoAdmins(adminPresenter);
        if (config.isShowNumberOfSubscribers()) {
            widgetBuilder.addFollowersRow(this._view.getFollowersWidget());
        }
        widgetBuilder.addVisitsRow(this._view.getVisitsWidget()).addTagRow().addDynamicAttributes();
        if (entityDetails.getMay().contains((Object)StaticEntityAction.ENTITY_MODIFY)) {
            this._view.showEditIcon(EntityEditHandler.token((HistoryManager)clientFactory.historyManager(), (EntityId)entityDetails.getId(), (CoreApp)entityApp, (EditEntityHistoryTokenTabName)EditEntityHistoryTokenTabName.BASE));
        } else {
            this._view.hideEditIcon();
        }
        String logo = entityDetails.getLogo();
        if (!config.isLogoActivated()) {
            this._view.hideLogo();
        } else if (may.contains((Object)StaticEntityAction.ENTITY_MODIFY) && may.contains((Object)Actions.entityModifyTab((TabNameForConfiguration)TabNameForConfiguration.IMAGE))) {
            this._view.showEditableLogo(entityApp, entityType, logo, EntityEditHandler.token((HistoryManager)clientFactory.historyManager(), (EntityId)id, (CoreApp)entityApp, (EditEntityHistoryTokenTabName)EditEntityHistoryTokenTabName.IMAGE));
        } else if (ClientStringUtil.hasText((String)logo)) {
            this._view.showLogo(entityApp, entityType, logo);
        } else {
            this._view.hideLogo();
        }
        this._view.setTitle(entityDetails.getName());
        1 x = new /* Unavailable Anonymous Inner Class!! */;
        this._view.addAttachHandler((AttachEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        InfoWidgetComponentEditorPresenter descriptionPresenter = new InfoWidgetComponentEditorPresenter(clientFactory.editorClientFactory(), entityDetails, clientFactory.getHostPropertiesBean().getEditorToolbar(), (InfoWidgetComponentPresenter)new /* Unavailable Anonymous Inner Class!! */, clientFactory.entityFactory().controller(), clientFactory.historyManager(), clientFactory.getGlobalEventManager(), clientFactory.entityFactory().entityConstants(entityDetails.getType()));
        if (descriptionPresenter.isEmpty()) {
            this._view.hideDescriptionEditorView();
        } else {
            this._view.setDescriptionEditorView(descriptionPresenter.getView());
        }
        adminPresenter.update();
        this.loadPrivacySettings(clientFactory, entityDetails);
        this.loadStatistics(clientFactory, id);
    }

    private void loadPrivacySettings(ClientFactory clientFactory, EntityDetails entityDetails) {
        this._view.hidePrivacySettingsView();
        clientFactory.entityFactory().controller().getEntityInfoTabPrivacySettings(entityDetails.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadStatistics(ClientFactory clientFactory, EntityId entityId) {
        clientFactory.entityFactory().controller().getStatisticsById(entityId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    public InformationTabView getView() {
        return this._view;
    }
}

