/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.personpopup;

import com.freiheit.toro.client.mediator.Callback;
import com.google.common.collect.Lists;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.NoActionCloseCallback;
import de.justsoftware.onx.common.presentation.client.ui.personpopup.PersonPopupManager;
import de.justsoftware.onx.design.client.util.CssClassUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class PopupContainer {
    private static final PopupPanel POPUP_INSTANCE = PopupContainer.createPopupInstance();
    private final PersonPopupManager.PopupOpenedHandler _openedHandler;
    private final Widget _relativeTo;
    private final boolean _fixEmptyRelativeTo;
    private final NoActionCloseCallback _closeCallback;
    private boolean _cancelOpening = false;
    private PopupPanel _popup;
    private Panel _popupRoot;
    private final CloseHandler<PopupPanel> _closeHandler;

    public PopupContainer(PersonPopupManager.PopupOpenedHandler openedHandler, Widget relativeTo, boolean fixEmptyRelativeTo, CloseHandler<PopupPanel> closeHandler) {
        this._closeHandler = closeHandler;
        this._openedHandler = openedHandler;
        this._relativeTo = relativeTo;
        this._fixEmptyRelativeTo = fixEmptyRelativeTo;
        this._closeCallback = new /* Unavailable Anonymous Inner Class!! */;
        this._relativeTo.addAttachHandler((AttachEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void openPopup() {
        if (this.alreadyShowing() || this.noRelativeTo()) {
            return;
        }
        if (this.anotherShowing()) {
            POPUP_INSTANCE.hide();
        }
        Panel popupRoot = this.getPopupRoot();
        this._openedHandler.popupOpened(this, popupRoot, (Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean anotherShowing() {
        return this._popup == null && POPUP_INSTANCE.isShowing();
    }

    private boolean noRelativeTo() {
        return !this._relativeTo.isAttached() || !this._relativeTo.isVisible();
    }

    private boolean alreadyShowing() {
        return this._popup != null && this._popup.isShowing();
    }

    public void closePopup() {
        if (this._popup != null) {
            this._popup.hide();
        }
    }

    @Nonnull
    PopupPanel getPopupPanel() {
        if (this._popup == null) {
            this._popup = POPUP_INSTANCE;
            ArrayList registrationContainer = Lists.newArrayListWithCapacity((int)1);
            registrationContainer.add(POPUP_INSTANCE.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */));
        }
        return this._popup;
    }

    @Nonnull
    private static PopupPanel createPopupInstance() {
        PopupPanel popup = new PopupPanel(true);
        popup.addStyleName(CssClassUtil.asWellFormedAndNamespaced((String)"person-popup"));
        popup.addStyleName("popover");
        popup.addStyleName("bottom");
        return popup;
    }

    @Nonnull
    private Panel getPopupRoot() {
        if (this._popupRoot == null) {
            this._popupRoot = new FlowPanel();
            FlowPanel arrow = new FlowPanel();
            arrow.addStyleName("arrow");
            this._popupRoot.add((Widget)arrow);
        }
        return this._popupRoot;
    }

    @Nonnull
    private static Widget determineRelativeToWithDimension(Widget relativeTo, boolean fixEmptyRelativeTo) {
        if (!fixEmptyRelativeTo) {
            return relativeTo;
        }
        if (relativeTo.getOffsetHeight() == 0 && relativeTo.getOffsetWidth() == 0) {
            return relativeTo.getParent();
        }
        return relativeTo;
    }

    @Nonnull
    public Widget getRelativeTo() {
        return this._relativeTo;
    }

    @Nonnull
    public NoActionCloseCallback getCloseCallback() {
        return this._closeCallback;
    }
}

