/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Node;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.HasReplacementAddPanel;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.ValidatorPanel;
import javax.annotation.Nonnull;

public final class ValidatorPanel
extends Composite
implements Validatable {
    private static final ValidatorPanelUIBinder UI_BINDER = (ValidatorPanelUIBinder)GWT.create(ValidatorPanelUIBinder.class);
    @UiField
    InlineFeedbackWidget _errorMessages;
    @UiField
    FlowPanel _widgetPanel;
    private Validatable _validatable;
    private Widget _validatableWidget;

    private ValidatorPanel() {
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._errorMessages.setVisible(false);
    }

    private <V extends Widget> void setValidateWidget(@Nonnull V validatableWidget) {
        this._validatableWidget = validatableWidget;
        this._validatable = (Validatable)validatableWidget;
        this._widgetPanel.clear();
        this._widgetPanel.add(this._validatableWidget);
    }

    public void clearError() {
        this._errorMessages.setVisible(false);
    }

    public Widget getValidatorWidget() {
        return this._validatableWidget;
    }

    public void validate() throws ValidationException {
        if (this._validatable != null) {
            this.clearError();
            try {
                this._validatable.validate();
            }
            catch (ValidationException e) {
                this.displayErrorMessage(InlineFeedbackWidget.InlineType.ERROR, e.getMessage());
                throw e;
            }
        }
    }

    public void displayErrorMessage(InlineFeedbackWidget.InlineType type, String errorMessage) {
        this._errorMessages.setMessage(errorMessage);
        this._errorMessages.setType(type);
        this._errorMessages.setVisible(true);
    }

    @Nonnull
    public static <V extends Widget> ValidatorPanel wrapValidateableWithValidatorPanel(@Nonnull V validatableWidget) {
        V widget = validatableWidget;
        Widget parent = widget.getParent();
        if (parent == null || !(parent instanceof HasReplacementAddPanel)) {
            throw new IllegalStateException("You can only wrap validateableWidget if the are attached to a parent which will implemented HasReplacementAddPanel");
        }
        HasReplacementAddPanel parentPanel = (HasReplacementAddPanel)parent;
        ValidatorPanel validatorWrapper = new ValidatorPanel();
        Element tempDiv = DOM.createDiv();
        Element node = widget.getElement();
        Node p = node.getParentNode();
        if (p != null) {
            p.insertBefore((Node)tempDiv, (Node)node);
        }
        parentPanel.addAndReplaceElement((Widget)validatorWrapper, (com.google.gwt.dom.client.Element)tempDiv);
        validatorWrapper.setValidateWidget(validatableWidget);
        return validatorWrapper;
    }

    public void setErrorMessage(@Nonnull InlineFeedbackWidget.InlineType type, @Nonnull String errorMessage) {
        this.clearError();
        this.displayErrorMessage(type, errorMessage);
    }
}

