/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.ListBox;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.AbstractReviewerSelectionView;
import de.justsoftware.onx.common.presentation.client.ui.ReviewerSelectionView;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.searchnew.presentation.client.CommonSearchMediator;
import javax.annotation.Nonnull;

public class ReviewerSelectionViewListBox
extends AbstractReviewerSelectionView {
    private static final String EMPTY_ITEM = "--";
    private static final int MAX_REVIEWER_IN_LIST = 100;
    private ListBox _personListBox;

    public ReviewerSelectionViewListBox(@Nonnull ReviewerSelectionView.Presenter presenter, @Nonnull ClientFactory clientFactory, @Nonnull EntityId entityId, int reviewStage) {
        super(presenter, clientFactory, entityId, reviewStage);
    }

    public void reset() {
        this._personListBox.setSelectedIndex(0);
    }

    public PersonId getValue() {
        String value = this._personListBox.getValue();
        if (value != null && !EMPTY_ITEM.equalsIgnoreCase(value)) {
            return PersonId.parse((String)value);
        }
        return null;
    }

    public void resetToDefault() {
        if (this._defaultSelection != null) {
            this._personListBox.setSelectedValue(((PersonId)this._defaultSelection.getId()).toString());
        }
    }

    @Nonnull
    protected Widget createPersonSelector() {
        this._personListBox = new ListBox();
        this._personListBox.addItem(EMPTY_ITEM);
        this._personListBox.setVisible(true);
        int reviewStage = this.getReviewStage();
        CommonSearchMediator.getInstance().getPotentialReviewersForEntity(this._entityId, reviewStage, 0, 100, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        return this._personListBox;
    }
}

