/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.ActionContainer;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.AbstractInPlaceEdit;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceEditable;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractInPlaceEdit<T>
extends Composite
implements HasValueChangeHandlers<T>,
InPlaceEditable {
    private static final AbstractInPlaceEditUiBinder UIBINDER = (AbstractInPlaceEditUiBinder)GWT.create(AbstractInPlaceEditUiBinder.class);
    protected final ClickHandler _editHandler = new /* Unavailable Anonymous Inner Class!! */;
    @UiField
    DeckPanel _deck;
    @UiField
    SimplePanel _showPanel;
    @UiField
    ActionContainer _showActions;
    @UiField
    ActionContainer _editActions;
    @UiField
    IconAnchor _editLink;
    @UiField
    SimplePanel _editPanel;
    @UiField
    IconAnchor _saveLink;
    @UiField
    SimplePanel _description;
    @UiField
    InlineFeedbackWidget _errorMessage;
    @UiField
    SimplePanel _waitPanel;
    private T _value;
    private boolean _asyncEnabled;
    private boolean _editable = true;
    private final List<SwitchModeHandler<T>> _switchModeHandlers = new ArrayList();
    private boolean _showControls = true;

    public AbstractInPlaceEdit(T value) {
        this.initWidget((Widget)UIBINDER.createAndBindUi((Object)this));
        this._errorMessage.hide();
        this._value = value;
        this.setViewMode(ViewMode.DECK_INDEX_VIEW);
        this._editLink.addClickHandler(this._editHandler);
        this._saveLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._description.setVisible(false);
    }

    protected void saveText() {
        String error = this.validate(this.getEditValue());
        if (error == null) {
            this._value = this.getEditValue();
            this._errorMessage.hide();
            this.setShowValue(this._value);
            if (this._asyncEnabled) {
                this.setWaitValue(this._value);
                this.setViewMode(ViewMode.DECK_INDEX_WAIT);
            } else {
                this.setViewMode(ViewMode.DECK_INDEX_VIEW);
            }
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this._value);
        } else {
            this._errorMessage.setMessage(error);
            this._errorMessage.show(InlineFeedbackWidget.InlineType.ERROR);
        }
    }

    public void cancelEdit() {
        this._errorMessage.hide();
        this.setViewMode(ViewMode.DECK_INDEX_VIEW);
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this._asyncEnabled = asyncEnabled;
    }

    protected abstract void setShowValue(T var1);

    protected abstract void setEditValue(T var1);

    protected abstract T getEditValue();

    protected abstract void setWaitValue(T var1);

    protected abstract String validate(T var1);

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    protected void setShowWidget(Widget showWidget) {
        this._showPanel.setWidget(showWidget);
    }

    protected void setEditWidget(Widget editWidget) {
        this._editPanel.setWidget(editWidget);
    }

    protected void setWaitWidget(Widget waitWidget) {
        this._waitPanel.setWidget(waitWidget);
    }

    public T getValue() {
        return (T)this._value;
    }

    public void setValue(T value) {
        this._value = value;
        if (this._deck.getVisibleWidget() == ViewMode.DECK_INDEX_VIEW.getIdx()) {
            this.setShowValue(this._value);
        } else if (this._deck.getVisibleWidget() == ViewMode.DECK_INDEX_EDIT.getIdx()) {
            this.setEditValue(this._value);
        } else if (this._deck.getVisibleWidget() == ViewMode.DECK_INDEX_WAIT.getIdx()) {
            this.setWaitValue(this._value);
        }
    }

    public void switchToViewMode() {
        this.setViewMode(ViewMode.DECK_INDEX_VIEW);
        this.setShowValue(this._value);
    }

    public void setViewMode(ViewMode mode) {
        if (this._deck.getVisibleWidget() != mode.getIdx()) {
            this._deck.showWidget(mode.getIdx());
            this.raiseSwitchModeEvent(mode);
        }
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this.updateEditLinkVisibility();
        if (!editable) {
            this.switchToViewMode();
        }
    }

    private void updateEditLinkVisibility() {
        this._editLink.setVisible(this._editable && this._showControls);
    }

    public void setDescription(String description) {
        this._description.setVisible(true);
        this._description.setWidget((Widget)new Label(description));
    }

    public void setEditLinkText(String text) {
        this._editLink.setText(text);
    }

    public boolean isAsyncEnabled() {
        return this._asyncEnabled;
    }

    @UiFactory
    public BasicConstants createBasicConstants() {
        return I18nMediator.BASIC_CONSTANTS;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean switchToEditMode() {
        this.setViewMode(ViewMode.DECK_INDEX_EDIT);
        this.setEditValue(this._value);
        return true;
    }

    public boolean isInViewMode() {
        return this._deck.getVisibleWidget() == ViewMode.DECK_INDEX_VIEW.getIdx();
    }

    public void saveIfInEditMode() {
        if (this._deck.getVisibleWidget() == ViewMode.DECK_INDEX_EDIT.getIdx()) {
            this.saveText();
        }
    }

    public void addShowAction(Widget action) {
        this._showActions.add(action);
    }

    public void removeShowAction(Widget action) {
        this._showActions.remove(action);
    }

    public void addEditAction(Widget action) {
        this._editActions.add(action);
    }

    public void removeEditAction(Widget action) {
        this._editActions.remove(action);
    }

    public KeyDownHandler getKeyDownHandler(boolean handleEnter) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setSaveLinkFloatRight(boolean floatRight) {
        if (floatRight) {
            this._saveLink.addStyleName("float-right");
        }
    }

    public void addSwitchModeHandler(SwitchModeHandler<T> handler) {
        this._switchModeHandlers.add(handler);
    }

    public void removeSwitchModeHandler(SwitchModeHandler<T> handler) {
        this._switchModeHandlers.remove(handler);
    }

    private void raiseSwitchModeEvent(ViewMode viewMode) {
        for (SwitchModeHandler switchModeHandler : this._switchModeHandlers) {
            switchModeHandler.onSwitchMode(this, viewMode);
        }
    }

    public void setShowControls(boolean showControls) {
        this._showControls = showControls;
        this._saveLink.setVisible(showControls);
        this.updateEditLinkVisibility();
    }
}

