/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client;

import com.google.common.collect.Lists;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.DataSuggestion;
import de.justsoftware.onx.common.presentation.client.ServerSideSuggestOracle;
import de.justsoftware.onx.common.presentation.client.SuggestionNotMatchQueryException;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class ServerSideSuggestOracle<T, U extends DataSuggestion<T>>
extends SuggestOracle {
    private static final int QUERY_DELAY = 250;
    protected SuggestRequestTimer _timer;
    protected String _additionalItemInfoStyleClass;

    private List<U> convertToFormattedSuggestions(String query, List<T> candidates) {
        ArrayList suggestions = Lists.newArrayListWithCapacity((int)candidates.size());
        for (T data : candidates) {
            String replacementString = this.getReplacementStringFromDataSuggestion(data);
            FlowPanel itemInfo = new FlowPanel();
            itemInfo.addStyleName("itemInfo");
            if (this._additionalItemInfoStyleClass != null) {
                itemInfo.addStyleName(this._additionalItemInfoStyleClass);
            }
            try {
                String locatedName = this.getLocatedName(query, replacementString);
                FlowPanel locatedNamePanel = new FlowPanel();
                locatedNamePanel.add((Widget)new HTML(locatedName));
                itemInfo.add((Widget)locatedNamePanel);
                suggestions.add(this.createSuggestion(itemInfo.toString(), replacementString, data));
            }
            catch (SuggestionNotMatchQueryException suggestionNotMatchQueryException) {}
        }
        return suggestions;
    }

    protected String getLocatedName(String queryString, String suggestString) throws SuggestionNotMatchQueryException {
        int index = 0;
        int cursor = 0;
        String query = StringUtil.normalizeSearch((String)queryString);
        String normalizedSuggestion = StringUtil.normalizeSearch((String)suggestString);
        StringBuilder locatedName = new StringBuilder();
        while ((index = normalizedSuggestion.indexOf(query, index)) != -1) {
            int endIndex = index + queryString.length();
            String part1 = this.escapeText(suggestString.substring(cursor, index));
            String part2 = this.escapeText(suggestString.substring(index, endIndex));
            cursor = endIndex;
            locatedName.append(part1).append("<strong>").append(part2).append("</strong>");
            index = endIndex;
        }
        if (cursor == 0) {
            throw new SuggestionNotMatchQueryException();
        }
        String end = this.escapeText(suggestString.substring(cursor));
        locatedName.append(end);
        return locatedName.toString();
    }

    public void setAdditionalItemInfoStyleClass(String additionalItemInfoStyleClass) {
        this._additionalItemInfoStyleClass = additionalItemInfoStyleClass;
    }

    protected abstract U createSuggestion(String var1, String var2, T var3);

    protected String escapeText(String escapeMe) {
        HTML convertMe = new HTML();
        convertMe.setText(escapeMe);
        return convertMe.getHTML();
    }

    public void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        this.cancelSuggestionRequest();
        this._timer = new SuggestRequestTimer(this, request, callback);
        this._timer.schedule(250);
    }

    public void cancelSuggestionRequest() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public boolean isDisplayStringHTML() {
        return true;
    }

    protected abstract void search(SuggestOracle.Request var1, String var2, SuggestOracle.Callback var3);

    protected abstract String getReplacementStringFromDataSuggestion(T var1);
}

