/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client;

import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.github.gwtbootstrap.client.ui.base.InlineLabel;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.shared.model.Link;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class LinkUtil {
    @Nonnull
    public static Widget getLinkWidget(Link link, boolean isToken, boolean showTooltip) {
        String href;
        String text = link.getTextOrHref("");
        String linkHref = link.getHref();
        if (StringUtil.isBlank((String)linkHref)) {
            InlineLabel l = new InlineLabel(text);
            if (showTooltip) {
                l.setTitle(text);
            }
            return l;
        }
        String string = href = isToken && !linkHref.startsWith("#") ? "#" + linkHref : linkHref;
        if (href.startsWith("#")) {
            InlineHyperlink h = new InlineHyperlink(text, href.substring(1));
            if (showTooltip) {
                h.setTitle(text);
            }
            return h;
        }
        String target = link.getTarget() == null ? "_blank" : link.getTarget();
        Anchor a = new Anchor(text, false, href);
        a.setTarget(target);
        if (showTooltip) {
            a.setTitle(text);
        }
        return a;
    }

    public static boolean isToken(String href) {
        return href.startsWith("#");
    }

    @Nonnull
    public static String getLinkString(Link link, boolean isToken, boolean wrapInDiv) {
        String text = ClientStringUtil.htmlEscape((String)link.getTextOrHref(""));
        Object divText = wrapInDiv ? "<div>" + text + "</div>" : text;
        String linkHref = link.getHref();
        if (StringUtil.isBlank((String)linkHref)) {
            return divText;
        }
        String href = ClientStringUtil.htmlEscape((String)(isToken ? "#" + linkHref : linkHref));
        String target = link.getTarget() == null ? (href.startsWith("#") ? "" : "_blank") : link.getTarget();
        return "<a href=\"" + href + "\" target=\"" + target + "\">" + (String)divText + "</a>";
    }

    @Nonnull
    public static String getLinkToNewsPost(String postId) {
        return "/news/posts/" + postId;
    }
}

