/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.CalendarDataProvider;
import de.justsoftware.onx.calendar.presentation.client.CalendarFeedTabPresenter;
import de.justsoftware.onx.calendar.presentation.client.CalendarViewHandler;
import de.justsoftware.onx.calendar.presentation.client.SearchAppointmentCalendarDataProvider;
import de.justsoftware.onx.calendar.presentation.client.ui.Calendar;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarViewDialogBox;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarViewInfoPopupPanel;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCClosePopupIcon;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.presentation.client.ui.NoActionCloseCallback;
import de.justsoftware.onx.common.presentation.client.ui.PopupCloseHelper;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import java.util.Date;
import javax.annotation.Nonnull;

public final class CalendarViewDialogBox
extends JCDialogBox {
    private final Calendar _calendar;
    private final EntityType _entityType;
    private final EntityConstants _entityConstants;
    private final JCButton _createButton;
    private final FlowPanel _mainPanel;
    private final FlowPanel _tabPanel;
    private final PopupCloseHelper _popupCloseHelper;
    private final ClientFactory _clientFactory;

    private CalendarViewDialogBox(boolean mayCreateAppointment, CalendarDataProvider dataProvider, Date selectedDate, EntityType entityType, ClientFactory clientFactory, boolean isMyMonthView) {
        super(false, true);
        super.addStyleName("calendar-popup");
        this._clientFactory = clientFactory;
        this._mainPanel = new FlowPanel();
        this._mainPanel.addStyleName("large");
        this._tabPanel = new FlowPanel();
        this._tabPanel.addStyleName("calendar-popup-tab");
        this._tabPanel.setVisible(false);
        this._mainPanel.add((Widget)this._tabPanel);
        this.setContent((IsWidget)this._mainPanel);
        this._entityType = entityType;
        this._entityConstants = clientFactory.localizedMessages().entityConstants(this._entityType);
        this._popupCloseHelper = clientFactory.commonClientFactory().newPopupCloseHelper();
        this._popupCloseHelper.ignoreElement((Element)this.getElement());
        for (CalendarViewInfoPopupPanel.PopupPriority popupPriority : CalendarViewInfoPopupPanel.PopupPriority.values()) {
            this._popupCloseHelper.ignoreElement((Element)popupPriority.getInstance().getElement());
        }
        this._popupCloseHelper.setHandler((PopupCloseHelper.ClosePopupClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._calendar = new Calendar(mayCreateAppointment, dataProvider, selectedDate, 1068, 575, entityType, (CalendarViewHandler)new /* Unavailable Anonymous Inner Class!! */, clientFactory);
        this._mainPanel.add((Widget)this._calendar);
        this._createButton = new JCButton();
        this._createButton.setTitle(this._entityConstants.createEntity());
        this._createButton.setIcon(IconType.PLUS);
        this._createButton.addStyleName("calendar-create-button");
        if (mayCreateAppointment) {
            this._createButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this._calendar.addButtonToCreateButtonPanel(this._createButton);
        }
        if (isMyMonthView) {
            this.setText(this._entityConstants.myMonthView());
            this.initTab(clientFactory, entityType);
        } else {
            this.setText(this._entityConstants.monthView());
        }
    }

    private void initTab(@Nonnull ClientFactory clientFactory, @Nonnull EntityType entityType) {
        this.getCaption().clearActions();
        IconAnchor iCalIcon = new IconAnchor();
        iCalIcon.setIcon(IconType.SHARE);
        iCalIcon.setIconSize(IconSize.LARGE);
        4 toggleClickHandler = new /* Unavailable Anonymous Inner Class!! */;
        this._tabPanel.add(new CalendarFeedTabPresenter(clientFactory, entityType).getView());
        FocusPanel closeTabClickArea = new FocusPanel();
        closeTabClickArea.addStyleName("close-tab-click-area");
        this._tabPanel.add((Widget)closeTabClickArea);
        closeTabClickArea.addClickHandler((ClickHandler)toggleClickHandler);
        iCalIcon.addClickHandler((ClickHandler)toggleClickHandler);
        this.getCaption().addAction((Widget)iCalIcon);
        this.getCaption().addAction((Widget)new JCClosePopupIcon((NoActionCloseCallback)this, IconSize.LARGE));
    }

    protected void onLoad() {
        super.onLoad();
        this._popupCloseHelper.registerHandler();
    }

    protected void onUnload() {
        super.onUnload();
        this._popupCloseHelper.unregisterHandler();
    }

    protected JCDialogBox.Size getSize() {
        return JCDialogBox.Size.UNRESTRICTED;
    }

    public void setSelectedDate(Date selectedDate) {
        this._calendar.setSelectedDate(selectedDate);
    }

    public Date getSelectedDate() {
        return this._calendar.getSelectedDate();
    }

    public void hide() {
        CalendarViewInfoPopupPanel.hidePopups((CalendarViewInfoPopupPanel.PopupPriority)CalendarViewInfoPopupPanel.PopupPriority.PRIMARY);
        super.hide();
    }

    public static void showCalendarViewDialogBox(ClientFactory clientFactory, boolean showCreateButton, @Nonnull SearchParameters searchParameters, Date selectedDate, @Nonnull EntityType entityType, boolean isMyMonthView) {
        new CalendarViewDialogBox(showCreateButton, (CalendarDataProvider)new SearchAppointmentCalendarDataProvider(clientFactory, searchParameters), selectedDate, entityType, clientFactory, isMyMonthView).show();
    }
}

