/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.i18n.AlbumConstants;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.AlbumMediator;
import de.justsoftware.onx.album.presentation.client.ui.AlbumsOverviewWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.BreadCrumbWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JustBasePageImpl;
import de.justsoftware.onx.common.presentation.client.ui.OnxPage;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidget;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidgetProvider;
import de.justsoftware.onx.common.presentation.client.ui.SmallHeaderView;
import de.justsoftware.onx.common.presentation.client.ui.SmallHeaderViewPresenter;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemType;
import javax.annotation.Nonnull;

public class AlbumsOverviewWidget
extends JustBasePageImpl {
    private static final int ALBUMS_PER_PAGE = 6;
    private static final AlbumConstants ALBUM = I18nMediator.ALBUM;

    public AlbumsOverviewWidget(@Nonnull GlobalId parentId, boolean displayHeaderAndFooter, @Nonnull ClientFactory clientFactory) {
        OnxPage content = new OnxPage();
        FlowPanel albumsPanel = new FlowPanel();
        FlowPanel addButtonsPanel = new FlowPanel();
        JCButton uploadImages = new JCButton(ALBUM.uploadPhotos());
        content.addStyleName("badges-panel");
        uploadImages.addStyleName("btn-block");
        addButtonsPanel.add((Widget)uploadImages);
        if (!ItemType.ENTITY.equals((Object)parentId.getType())) {
            BreadCrumbWidget breadcrumb = new BreadCrumbWidget();
            breadcrumb.add(I18nMediator.ALBUM.pictures());
            content.add(ComponentPosition.CENTER, (IsWidget)breadcrumb);
        }
        content.add(ComponentPosition.BOTTOM_LEFT, (IsWidget)albumsPanel);
        content.add(ComponentPosition.BOTTOM_RIGHT, (IsWidget)addButtonsPanel);
        if (displayHeaderAndFooter) {
            SmallHeaderView headerView = new SmallHeaderViewPresenter(clientFactory).getView();
            BreadCrumbWidget breadCrumb = new BreadCrumbWidget();
            breadCrumb.add(parentId);
            breadCrumb.add(ALBUM.pictures());
            headerView.setBreadcrumb(breadCrumb);
            this.initWidget((IsWidget)headerView, (IsWidget)content);
        } else {
            this.initWidget((Widget)content);
        }
        PanelPagingWidget albumPager = new PanelPagingWidget(6, (Panel)new FlowPanel(), (PanelPagingWidgetProvider)new AlbumsOverviewPagingWidgetProvider(parentId));
        albumsPanel.add((Widget)albumPager);
        albumPager.update();
        uploadImages.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        AlbumMediator.getInstance().getAlbumsByParentId(parentId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

