/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.client.event;

import com.freiheit.toro.client.event.GlobalEventBus;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.events.ToggleJustContextSearchEvent;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.EntityVersionClientFactory;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.design.shared.model.ThemeId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class GlobalEventManager {
    private static GlobalEventManager _instance;
    private GlobalEventBus _eventBus;
    private EntityVersionClientFactory _entityVersionClientFactory;
    private DateFormatter _dateFormatter;

    private GlobalEventManager() {
    }

    @Nonnull
    public static GlobalEventManager getInstance() {
        if (_instance == null) {
            _instance = new GlobalEventManager();
        }
        return _instance;
    }

    public void init(GlobalEventBus eventBus, ClientFactory clientFactory) {
        this._eventBus = eventBus;
        this._entityVersionClientFactory = clientFactory.entityVersionFactory();
        this._dateFormatter = clientFactory.dateFormatter();
        EventManager eventManager = clientFactory.eventManager();
        this.registerJustContextNavigationHandlers(eventManager);
        this.registerEventHandler(clientFactory);
        this.registerItemChangedEvent(eventManager);
    }

    private void registerItemChangedEvent(EventManager eventManager) {
        this._eventBus.addEventHandler(GlobalEventBus.GlobalEvent.ITEM_UPDATED_EVENT, (event, payload) -> {
            ItemId itemId = ItemId.parseSafe((String)payload.toString());
            if (itemId != null) {
                itemId.accept((ItemIdVisitor)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                LoggingUtil.debug((Object)"could not parse itemId ", (String)payload.toString());
            }
        });
    }

    private void registerEventHandler(ClientFactory clientFactory) {
        this._eventBus.addEventHandler(GlobalEventBus.GlobalEvent.OPEN_VERSION_RELEASE_REQUEST_POPUP, (event, payload) -> {
            EntityVersionId entityVersionId = EntityVersionId.parse((String)payload.toString());
            if (entityVersionId != null) {
                this._entityVersionClientFactory.controller().getVersionReviewData(entityVersionId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        this._eventBus.addEventHandler(GlobalEventBus.GlobalEvent.OPEN_VERSION_RELEASE_REQUEST_DECLINED_POPUP, (event, payload) -> {
            EntityVersionId entityVersionId = EntityVersionId.parse((String)payload.toString());
            if (entityVersionId != null) {
                this._entityVersionClientFactory.controller().getVersionReviewData(entityVersionId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        this._eventBus.addEventHandler(GlobalEventBus.GlobalEvent.OPEN_VERSION_RELEASE_REQUEST_ACCEPTED_POPUP, (event, payload) -> {
            EntityVersionId entityVersionId = EntityVersionId.parse((String)payload.toString());
            if (entityVersionId != null) {
                this._entityVersionClientFactory.controller().getVersionReviewData(entityVersionId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
    }

    private void registerJustContextNavigationHandlers(EventManager eventManager) {
        eventManager.registerListener(ToggleJustContextSearchEvent.class, event -> this._eventBus.fireEvent(GlobalEventBus.GlobalEvent.TOGGLE_JUST_CONTEXT_SEARCH_EVENT, (GlobalEventBus.EventPayload)GlobalEventBus.EventPayload.create().set("open", event.isOpen())));
    }

    public void fireEvent(GlobalEventBus.GlobalEvent ev, @Nullable GlobalEventBus.EventPayload payload) {
        if (this._eventBus == null) {
            return;
        }
        this._eventBus.fireEvent(ev, payload);
    }

    public void fireStartConversationWithPersonEvent(PersonId personId) {
        if (this._eventBus == null) {
            return;
        }
        this._eventBus.fireEvent(GlobalEventBus.GlobalEvent.START_CHAT_WITH_PERSON_EVENT, (GlobalEventBus.EventPayload)GlobalEventBus.EventPayload.create().set("profileId", personId.asProfileId().asString()));
    }

    @CheckForNull
    private static String toString(@CheckForNull ThemeId themeId) {
        if (themeId == null) {
            return null;
        }
        return "THEME," + themeId.toString();
    }

    private void fireEventWithThemeId(GlobalEventBus.GlobalEvent event, @Nullable String themeId) {
        this._eventBus.fireEvent(event, (GlobalEventBus.EventPayload)GlobalEventBus.EventPayload.create().set("themeId", themeId));
    }

    public void fireRenderWikiEditLink(String componentName, GlobalEventBus.Callback clickCallback, String name, int position) {
        this.fireEvent(GlobalEventBus.GlobalEvent.RENDER_WIKI_EDIT_LINK, (GlobalEventBus.EventPayload)((GlobalEventBus.EventPayload)((GlobalEventBus.EventPayload)GlobalEventBus.EventPayload.create().set("component", componentName)).set("callback", clickCallback).set("name", name)).set("position", position));
    }

    public void fireDeactivateWikiEditLink() {
        this.fireEvent(GlobalEventBus.GlobalEvent.DEACTIVATE_WIKI_EDIT_LINK, null);
    }

    public void fireActivateWikiEditLink() {
        this.fireEvent(GlobalEventBus.GlobalEvent.ACTIVATE_WIKI_EDIT_LINK, null);
    }

    public void fireLockWikiEditLink(String componentName, boolean locked) {
        this.fireEvent(GlobalEventBus.GlobalEvent.LOCK_WIKI_EDIT_LINK, (GlobalEventBus.EventPayload)((GlobalEventBus.EventPayload)GlobalEventBus.EventPayload.create().set("component", componentName)).set("locked", locked));
    }

    public void fireRemoveWikiEditLink(String componentName) {
        GlobalEventManager.getInstance().fireEvent(GlobalEventBus.GlobalEvent.REMOVE_WIKI_EDIT_LINK, (GlobalEventBus.EventPayload)GlobalEventBus.EventPayload.create().set("component", componentName));
    }

    public void fireAdjustEntityScrollPosition(int extraOffset) {
        this.fireEvent(GlobalEventBus.GlobalEvent.ADJUST_ENTITY_SCROLL_POSITION, (GlobalEventBus.EventPayload)GlobalEventBus.EventPayload.create().set("extraOffset", extraOffset));
    }
}

