/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.admin.presentation.ui;

import com.freiheit.toro.admin.presentation.ui.LicenseInfoPopup;
import com.freiheit.toro.client.ui.MessagePopup;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import de.justsoftware.onx.administration.shared.i18n.AdministrationMessages;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.license.shared.model.LicenseInfo;
import java.util.Date;

public class LicenseInfoPopup
extends MessagePopup {
    private static final LicenseInfoPopupUIBinder UI_BINDER = (LicenseInfoPopupUIBinder)GWT.create(LicenseInfoPopupUIBinder.class);
    @UiField
    Label _domains;
    @UiField
    Label _expiry;
    @UiField
    Label _totalUserLicense;
    @UiField
    Label _usedUserLicense;
    @UiField
    Label _remainingUserLicense;

    public LicenseInfoPopup(LicenseInfo licenseInfo, ClientFactory clientFactory) {
        super(false, true);
        this.setType(2);
        this.setContent((IsWidget)UI_BINDER.createAndBindUi((Object)this));
        AdministrationMessages administrationMessages = clientFactory.localizedMessages().administration();
        boolean hasValidLicense = licenseInfo.getDomains() != null;
        String domains = hasValidLicense ? licenseInfo.getDomains() : administrationMessages.unlicensed();
        DateWithoutTimezone expiry = licenseInfo.getExpiry();
        String formattedExpirationDate = expiry != null ? clientFactory.dateFormatter().formatDate((Date)expiry) : administrationMessages.licenseUnlimited();
        boolean unlimitedUserLicense = licenseInfo.getMaxUserLicense() == Integer.MAX_VALUE;
        String totalUserLicense = unlimitedUserLicense ? administrationMessages.licenseUnlimited() : String.valueOf(licenseInfo.getMaxUserLicense());
        String remainingUserLicense = unlimitedUserLicense ? administrationMessages.licenseUnlimited() : String.valueOf(licenseInfo.getMaxUserLicense() - licenseInfo.getUsedUserLicense());
        this._domains.setText(administrationMessages.licenseForDomains(domains));
        this._expiry.setText(administrationMessages.licenseExpirationDate(formattedExpirationDate));
        this._totalUserLicense.setText(administrationMessages.totalUserLicense(totalUserLicense));
        this._usedUserLicense.setText(administrationMessages.usedUserLicense(licenseInfo.getUsedUserLicense()));
        this._remainingUserLicense.setText(administrationMessages.remainingUserLicense(remainingUserLicense));
    }
}

