/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.kafka;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import de.justsoftware.search.kafka.KafkaConfiguration;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u0017J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0012Ja\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\r\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f2\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0012\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\nH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/search/kafka/KafkaConfiguration;", "", "bootstrapServers", "", "defaultMaxChunkSize", "", "(Ljava/lang/String;I)V", "createStringProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "defaultConsumerConfig", "Ljava/util/Properties;", "groupId", "defaultKafkaListenerContainerFactory", "Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "K", "V", "keyDeserializer", "Lorg/apache/kafka/common/serialization/Deserializer;", "valueDeserializer", "maxChunkSize", "maxTimeout", "(Ljava/lang/String;Lorg/apache/kafka/common/serialization/Deserializer;Lorg/apache/kafka/common/serialization/Deserializer;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "defaultProducerConfig", "ClosingKafkaProducer", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nKafkaConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaConfiguration.kt\nde/justsoftware/search/kafka/KafkaConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TimeUtils.kt\nde/justsoftware/search/util/TimeUtilsKt\n*L\n1#1,92:1\n1#2:93\n15#3:94\n14#3:95\n*S KotlinDebug\n*F\n+ 1 KafkaConfiguration.kt\nde/justsoftware/search/kafka/KafkaConfiguration\n*L\n66#1:94\n66#1:95\n*E\n"})
public class KafkaConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    private final int defaultMaxChunkSize;
    @NotNull
    public static final String KAFKA_STRING_PRODUCER = "KAFKA_STRING_PRODUCER";

    public KafkaConfiguration(@Value(value="${spring.kafka.bootstrap-servers}") @NotNull String bootstrapServers, @Value(value="${kafka.consumer-max-chunk-size:100}") int defaultMaxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
        this.defaultMaxChunkSize = defaultMaxChunkSize;
    }

    @Bean(name={"KAFKA_STRING_PRODUCER"}, destroyMethod="close")
    @NotNull
    public KafkaCleaningProducer<String, String> createStringProducer() {
        return (KafkaCleaningProducer)new KafkaCleaningProducerImpl((Producer)new ClosingKafkaProducer(this.defaultProducerConfig()), arg_0 -> KafkaConfiguration.createStringProducer$lambda$0(this, arg_0));
    }

    private Properties defaultConsumerConfig(String groupId) {
        Properties properties;
        block0: {
            String string;
            Properties $this$defaultConsumerConfig_u24lambda_u242 = properties = new Properties();
            boolean bl = false;
            $this$defaultConsumerConfig_u24lambda_u242.put("bootstrap.servers", this.bootstrapServers);
            $this$defaultConsumerConfig_u24lambda_u242.put("enable.auto.commit", "false");
            $this$defaultConsumerConfig_u24lambda_u242.put("auto.offset.reset", "earliest");
            $this$defaultConsumerConfig_u24lambda_u242.put("max.poll.records", (Object)this.defaultMaxChunkSize);
            String string2 = groupId;
            if (string2 == null) break block0;
            String $this$defaultConsumerConfig_u24lambda_u242_u24lambda_u241 = string = string2;
            boolean bl2 = false;
            $this$defaultConsumerConfig_u24lambda_u242.put("group.id", groupId);
        }
        return properties;
    }

    private Properties defaultProducerConfig() {
        Properties properties;
        Properties $this$defaultProducerConfig_u24lambda_u243 = properties = new Properties();
        boolean bl = false;
        $this$defaultProducerConfig_u24lambda_u243.put("bootstrap.servers", this.bootstrapServers);
        $this$defaultProducerConfig_u24lambda_u243.put("acks", "all");
        $this$defaultProducerConfig_u24lambda_u243.put("retries", (Object)0);
        $this$defaultProducerConfig_u24lambda_u243.put("batch.size", (Object)16384);
        $this$defaultProducerConfig_u24lambda_u243.put("linger.ms", (Object)1);
        $this$defaultProducerConfig_u24lambda_u243.put("buffer.memory", (Object)0x2000000);
        return properties;
    }

    private <K, V> ConcurrentKafkaListenerContainerFactory<K, V> defaultKafkaListenerContainerFactory(String groupId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Integer maxChunkSize, Integer maxTimeout) {
        ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory;
        ConcurrentKafkaListenerContainerFactory $this$defaultKafkaListenerContainerFactory_u24lambda_u246 = concurrentKafkaListenerContainerFactory = new ConcurrentKafkaListenerContainerFactory();
        boolean bl = false;
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff();
        int $this$hours$iv = 1;
        boolean $i$f$getHours = false;
        long $this$hours$iv$iv = $this$hours$iv;
        boolean $i$f$getHours2 = false;
        Duration duration = Duration.ofHours($this$hours$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(...)");
        exponentialBackOff.setMaxElapsedTime(duration.toMillis());
        Properties properties = this.defaultConsumerConfig(groupId);
        Intrinsics.checkNotNull((Object)properties, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any?>");
        Map config = TypeIntrinsics.asMutableMap((Object)properties);
        Integer n = maxChunkSize;
        if (n != null) {
            Integer n2 = n;
            int $this$defaultKafkaListenerContainerFactory_u24lambda_u246_u24lambda_u244 = ((Number)n2).intValue();
            boolean bl2 = false;
            config.put("max.poll.records", maxChunkSize);
        }
        Integer n3 = maxTimeout;
        if (n3 != null) {
            Integer n4 = n3;
            int $this$defaultKafkaListenerContainerFactory_u24lambda_u246_u24lambda_u245 = ((Number)n4).intValue();
            boolean bl3 = false;
            config.put("fetch.max.wait.ms", maxTimeout);
        }
        $this$defaultKafkaListenerContainerFactory_u24lambda_u246.setBatchListener(Boolean.valueOf(true));
        $this$defaultKafkaListenerContainerFactory_u24lambda_u246.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler((BackOff)exponentialBackOff));
        $this$defaultKafkaListenerContainerFactory_u24lambda_u246.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(config, (Deserializer)new ErrorHandlingDeserializer(keyDeserializer), (Deserializer)new ErrorHandlingDeserializer(valueDeserializer)));
        return concurrentKafkaListenerContainerFactory;
    }

    static /* synthetic */ ConcurrentKafkaListenerContainerFactory defaultKafkaListenerContainerFactory$default(KafkaConfiguration kafkaConfiguration, String string, Deserializer deserializer, Deserializer deserializer2, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: defaultKafkaListenerContainerFactory");
        }
        if ((n3 & 8) != 0) {
            n = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        return kafkaConfiguration.defaultKafkaListenerContainerFactory(string, deserializer, deserializer2, n, n2);
    }

    private static final Consumer createStringProducer$lambda$0(KafkaConfiguration this$0, TopicPartition topicPartition) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)topicPartition, (Properties)this$0.defaultConsumerConfig(null));
    }
}

