/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.config.security;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.search.config.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lde/justsoftware/search/config/security/WebSecurityConfiguration;", "", "()V", "configureSecurity", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "Companion", "search-service"})
public class WebSecurityConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INTERNAL_API = "/internal/**";

    @Bean
    @NotNull
    public SecurityFilterChain configureSecurity(@NotNull HttpSecurity http, @NotNull JwtVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        RequestMatcher[] requestMatcherArray = new RequestMatcher[]{new AntPathRequestMatcher(INTERNAL_API)};
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter = new JwtAuthenticationProcessingFilter(jwtVerifier).applyIgnoreFilterMatcher((RequestMatcher)new OrRequestMatcher(requestMatcherArray));
        Intrinsics.checkNotNullExpressionValue((Object)jwtAuthenticationProcessingFilter, (String)"applyIgnoreFilterMatcher(...)");
        JwtAuthenticationProcessingFilter jwt = jwtAuthenticationProcessingFilter;
        http.sessionManagement(WebSecurityConfiguration::configureSecurity$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::configureSecurity$lambda$1).headers(WebSecurityConfiguration::configureSecurity$lambda$2).anonymous(Customizer.withDefaults()).authorizeHttpRequests(WebSecurityConfiguration::configureSecurity$lambda$3).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void configureSecurity$lambda$0(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void configureSecurity$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void configureSecurity$lambda$2(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void configureSecurity$lambda$3(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        String[] stringArray = new String[]{INTERNAL_API};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }
}

