/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.permission.business.config.model.Replacement;
import de.justsoftware.permission.business.offsets.ConsumerOffsetService;
import de.justsoftware.permission.business.role.RoleService;
import de.justsoftware.permission.business.role.model.DirectlyResolvableRole;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.permission.kafka.AbstractKafkaConsumer;
import de.justsoftware.permission.kafka.ConsumerUtils;
import de.justsoftware.permission.kafka.KafkaConfigurationProvider;
import de.justsoftware.permission.persistence.TransactionSupport;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class MultiRoleConsumer
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.permission.multiRoleAssignment";
    private static final Logger LOG = LoggerFactory.getLogger(MultiRoleConsumer.class);
    private final RoleService _roleService;

    @Autowired
    public MultiRoleConsumer(KafkaConfigurationProvider configurationProvider, RoleService roleService, ConsumerOffsetService consumerOffsetService, TransactionSupport transactionSupport) {
        this(() -> configurationProvider.stringConsumer("just.permission.MultiRoleConsumer-" + configurationProvider.getKafkaGroupIdentifier()), roleService, consumerOffsetService, configurationProvider, transactionSupport);
    }

    @VisibleForTesting
    MultiRoleConsumer(Supplier<Consumer<String, String>> consumerSupplier, RoleService roleService, ConsumerOffsetService consumerOffsetService, KafkaConfigurationProvider configurationProvider, TransactionSupport transactionSupport) {
        super(consumerSupplier, TOPIC, 0, consumerOffsetService, configurationProvider, transactionSupport);
        this._roleService = roleService;
    }

    protected Logger getLog() {
        return LOG;
    }

    protected void process(ConsumerRecords<String, String> records) {
        HashMap consumed = new HashMap();
        records.forEach(record -> this.consumeRecord(consumed::put, record));
        this._roleService.replaceRoleReplacements(consumed);
    }

    private void consumeRecord(BiConsumer<DirectlyResolvableRole, Replacement> consumer, ConsumerRecord<String, String> record) {
        try {
            Role from = Role.valueOf((String)((String)record.key()));
            if (!(from instanceof DirectlyResolvableRole)) {
                LOG.warn("record key is not a resolvable role, ignoring record: {}", record);
                return;
            }
            DirectlyResolvableRole role = (DirectlyResolvableRole)from;
            String value = (String)record.value();
            if (StringUtils.isBlank((CharSequence)value)) {
                consumer.accept(role, Replacement.EMPTY);
            } else {
                JsonNode json = this.parseJson(value);
                if (json != null) {
                    consumer.accept(role, ConsumerUtils.parseReplacement((JsonNode)json));
                } else {
                    LOG.warn("record value is not parsable, ignoring record: {}", (Object)value);
                }
            }
        }
        catch (RuntimeException e) {
            LOG.warn("runtime exception during parsing record: {}", record);
        }
    }
}

