/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.graphql;

import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.types.errors.ErrorDetail;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import de.justsoftware.news.auth.exceptions.NotAuthorizedException;
import de.justsoftware.news.auth.exceptions.NotFoundException;
import de.justsoftware.news.domain.error.NewsException;
import de.justsoftware.news.domain.post.error.PostAlreadyUpdatedException;
import de.justsoftware.news.graphql.ApiError;
import de.justsoftware.news.graphql.ErrorHandler;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/news/graphql/ErrorHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "()V", "defaultHandler", "Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "getApiError", "Lde/justsoftware/news/graphql/ApiError;", "exception", "Lde/justsoftware/news/domain/error/NewsException;", "handleException", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "Companion", "news-service"})
public class ErrorHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultDataFetcherExceptionHandler defaultHandler = new DefaultDataFetcherExceptionHandler();
    @NotNull
    private static final Logger log;

    private ApiError getApiError(NewsException exception) {
        return exception instanceof PostAlreadyUpdatedException ? ApiError.POST_ALREADY_UPDATED_ERROR : ApiError.GENERAL_ERROR;
    }

    @Nullable
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        CompletableFuture<DataFetcherExceptionHandlerResult> completableFuture;
        TypedGraphQLError customError;
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        Throwable exception = handlerParameters.getException();
        log.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
        Throwable throwable = exception;
        if (throwable instanceof IllegalArgumentException) {
            TypedGraphQLError.Builder builder = TypedGraphQLError.newBadRequestBuilder().path(handlerParameters.getPath()).message("Bad Request").errorDetail((ErrorDetail)ErrorDetail.Common.INVALID_ARGUMENT);
            Intrinsics.checkNotNull((Object)exception);
            v1 = builder.origin(exception.getClass().getSimpleName() + ": " + exception.getMessage()).build();
        } else if (throwable instanceof NotAuthorizedException) {
            v1 = TypedGraphQLError.newPermissionDeniedBuilder().path(handlerParameters.getPath()).origin(exception.getMessage()).message("Not authorized").build();
        } else if (throwable instanceof NotFoundException) {
            v1 = TypedGraphQLError.newNotFoundBuilder().origin(exception.getMessage()).path(handlerParameters.getPath()).build();
        } else if (throwable instanceof NewsException) {
            TypedGraphQLError.Builder builder = TypedGraphQLError.newConflictBuilder().message(exception.getMessage()).path(handlerParameters.getPath());
            Intrinsics.checkNotNull((Object)exception);
            v1 = builder.extensions(MapsKt.mapOf((Pair)new Pair((Object)"apiError", (Object)this.getApiError((NewsException)exception)))).build();
        } else {
            v1 = customError = throwable instanceof RuntimeException ? TypedGraphQLError.newInternalErrorBuilder().message("Internal Server Error").origin(exception.getMessage()).path(handlerParameters.getPath()).build() : null;
        }
        if (customError == null) {
            completableFuture = CompletableFuture.completedFuture(this.defaultHandler.handleException(handlerParameters).get());
        } else {
            log.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
            completableFuture = CompletableFuture.completedFuture(DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)customError).build());
        }
        return completableFuture;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

