/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.migration.InsertNewMention;
import de.justsoftware.news.domain.migration.MentionMigrationService;
import de.justsoftware.news.domain.migration.NewMention;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.UserId;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0012J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0012R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/news/domain/migration/MentionMigrationService;", "", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "(Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;)V", "<set-?>", "", "hasError", "getHasError", "()Z", "convertQuillMention", "jsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "migrateQuillMentions", "", "updateCommentJsonContent", "comment", "Lde/justsoftware/news/domain/comment/PostComment;", "updatePostJsonContent", "post", "Lde/justsoftware/news/domain/post/Post;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nMentionMigrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MentionMigrationService.kt\nde/justsoftware/news/domain/migration/MentionMigrationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1855#2,2:130\n*S KotlinDebug\n*F\n+ 1 MentionMigrationService.kt\nde/justsoftware/news/domain/migration/MentionMigrationService\n*L\n86#1:130,2\n*E\n"})
public class MentionMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    private boolean hasError;
    @NotNull
    private static final String MENTION_PREFIX = "@";
    @NotNull
    private static final Logger log;

    public MentionMigrationService(@NotNull PostRepo postRepo, @NotNull PostCommentRepo postCommentRepo) {
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        this.postRepo = postRepo;
        this.postCommentRepo = postCommentRepo;
        this.hasError = true;
    }

    public final boolean getHasError() {
        return this.hasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @EventListener(value={ApplicationReadyEvent.class})
    public void migrateQuillMentions() {
        Stream it2;
        log.info("Starting mention migration.");
        this.hasError = false;
        AutoCloseable autoCloseable = this.postRepo.findWithLegacyMentions();
        Throwable throwable = null;
        try {
            it2 = (Stream)autoCloseable;
            boolean bl = false;
            it2.forEach(arg_0 -> MentionMigrationService.migrateQuillMentions$lambda$1$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        log.info("Post mention migration completed.");
        autoCloseable = this.postCommentRepo.findWithLegacyMentions();
        throwable = null;
        try {
            it2 = (Stream)autoCloseable;
            boolean bl = false;
            it2.forEach(arg_0 -> MentionMigrationService.migrateQuillMentions$lambda$3$lambda$2((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        log.info("Mention migration completed.");
    }

    private void updatePostJsonContent(Post post) {
        JsonNode jsonNode = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).readTree(post.getJsonContent());
        if (jsonNode.get("ops") == null) {
            return;
        }
        try {
            Intrinsics.checkNotNull((Object)jsonNode);
            if (this.convertQuillMention(jsonNode)) {
                log.info("Migrating post " + post.getId().toTypedString());
                PostId postId = post.getId();
                String string = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).writeValueAsString((Object)jsonNode);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                this.postRepo.updateJsonContent(postId, string);
            }
        }
        catch (Exception exception) {
            this.hasError = true;
            log.error("Error migrating mentions for " + post.getId(), (Throwable)exception);
        }
    }

    private void updateCommentJsonContent(PostComment comment) {
        JsonNode jsonNode = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).readTree(comment.getJsonContent());
        if (jsonNode.get("ops") == null) {
            return;
        }
        try {
            Intrinsics.checkNotNull((Object)jsonNode);
            if (this.convertQuillMention(jsonNode)) {
                log.info("Migrating comment " + comment.getId().toTypedString());
                CommentId commentId = comment.getId();
                String string = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).writeValueAsString((Object)jsonNode);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                this.postCommentRepo.updateJsonContent(commentId, string);
            }
        }
        catch (Exception exception) {
            this.hasError = true;
            log.error("Error migrating mentions for " + comment.getId(), (Throwable)exception);
        }
    }

    private boolean convertQuillMention(JsonNode jsonNode) {
        boolean jsonUpdated = false;
        JsonNode jsonNode2 = jsonNode.get("ops");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"get(...)");
        Iterable $this$forEach$iv = (Iterable)jsonNode2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            JsonNode jsonNode3;
            JsonNode jsonNode4;
            JsonNode rootNode = (JsonNode)element$iv;
            boolean bl = false;
            JsonNode jsonNode5 = jsonNode4 = rootNode.get("attributes");
            if (jsonNode5 == null) continue;
            Intrinsics.checkNotNull((Object)jsonNode5);
            JsonNode attributes = jsonNode4;
            JsonNode jsonNode6 = jsonNode3 = attributes.get("mention");
            if (jsonNode6 == null) continue;
            Intrinsics.checkNotNull((Object)jsonNode6);
            JsonNode mention = jsonNode3;
            String insert = rootNode.get("insert").asText();
            Intrinsics.checkNotNull((Object)rootNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            ObjectNode objectNode = (ObjectNode)rootNode;
            String string2 = mention.asText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
            UserId userId = UserId.Companion.fromString(string2);
            log.info("Migrating mention: " + insert);
            objectNode.remove("attributes");
            objectNode.remove("insert");
            String string3 = userId.toTypedString();
            String string4 = "#/!profile." + userId.getValue();
            Intrinsics.checkNotNull((Object)insert);
            if (StringsKt.startsWith$default((String)insert, (String)MENTION_PREFIX, (boolean)false, (int)2, null)) {
                String string5 = insert.substring(1);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else {
                string = insert;
            }
            String string6 = string;
            Intrinsics.checkNotNull((Object)string6);
            InsertNewMention newMention = new InsertNewMention(new NewMention("0", MENTION_PREFIX, string3, string4, string6));
            JsonNode migratedJsonNode = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).valueToTree((Object)newMention);
            objectNode.putIfAbsent("insert", migratedJsonNode);
            log.info("Original json_content: " + rootNode);
            jsonUpdated = true;
        }
        return jsonUpdated;
    }

    private static final void migrateQuillMentions$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void migrateQuillMentions$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$updatePostJsonContent(MentionMigrationService $this, Post post) {
        $this.updatePostJsonContent(post);
    }

    public static final /* synthetic */ void access$updateCommentJsonContent(MentionMigrationService $this, PostComment comment) {
        $this.updateCommentJsonContent(comment);
    }

    static {
        Logger logger = LoggerFactory.getLogger(MentionMigrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

