/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.config;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.config.Config;
import de.justsoftware.news.domain.tenant.TenantRepo;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import io.micrometer.observation.annotation.Observed;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Observed
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/news/domain/config/ConfigService;", "", "tenantRepo", "Lde/justsoftware/news/domain/tenant/TenantRepo;", "(Lde/justsoftware/news/domain/tenant/TenantRepo;)V", "getConfig", "Lde/justsoftware/news/domain/config/Config;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
public class ConfigService {
    @NotNull
    private final TenantRepo tenantRepo;

    public ConfigService(@NotNull TenantRepo tenantRepo) {
        Intrinsics.checkNotNullParameter((Object)tenantRepo, (String)"tenantRepo");
        this.tenantRepo = tenantRepo;
    }

    @NotNull
    public Config getConfig(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        authContext.checkRead((ItemId)tenantId);
        boolean isSuperAdmin = authContext.isSuperAdmin();
        return new Config(tenantId, authContext.mayCreateChannel(), isSuperAdmin);
    }
}

