/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import de.justsoftware.news.domain.comment.CountRowMapper;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Sort;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jdbc.repository.query.Modifying;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\r\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004J*\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H'J&\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u00032\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H'J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u000e\b\u0001\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H&J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H&J$\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00020\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"H'J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010$\u001a\u00020\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0 H&J\u0012\u0010&\u001a\u00020\u00022\b\b\u0001\u0010'\u001a\u00020\u0003H&Jl\u0010(\u001a\u00020)2\b\b\u0001\u0010'\u001a\u00020\u00032\b\b\u0001\u0010*\u001a\u00020\b2\b\b\u0001\u0010+\u001a\u00020\u00162\b\b\u0001\u0010,\u001a\u00020\u00162\b\b\u0001\u0010$\u001a\u00020\u00102\b\b\u0001\u0010-\u001a\u00020\u00122\b\b\u0001\u0010.\u001a\u00020\u00122\b\b\u0001\u0010/\u001a\u00020\u00102\b\b\u0001\u00100\u001a\u00020\u000b2\b\b\u0001\u00101\u001a\u00020\u000bH'J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u000e\b\u0001\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0006H'J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u000e\b\u0001\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0006H'J\u001c\u00104\u001a\u00020)2\b\b\u0001\u0010'\u001a\u00020\u00032\b\b\u0001\u00105\u001a\u00020\u000bH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00066\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentRepo;", "Lorg/springframework/data/repository/CrudRepository;", "Lde/justsoftware/news/domain/comment/PostComment;", "Lde/justsoftware/news/id/CommentId;", "Lorg/springframework/data/repository/PagingAndSortingRepository;", "commentCountByPostIds", "", "Lkotlin/Pair;", "Lde/justsoftware/news/id/PostId;", "", "ids", "", "delete", "", "commentId", "deletedBy", "Lde/justsoftware/news/id/ProfileId;", "deletedAt", "Ljava/time/Instant;", "findAllByParentId", "", "itemId", "Lde/justsoftware/news/id/ItemId;", "sort", "Lde/justsoftware/news/util/Sort;", "findAllByParentIdIn", "parentIds", "findAllByParentIdOrderByCreatedAtAsc", "findAllByParentIdOrderByCreatedAtDesc", "findAllCommentsById", "kotlin.jvm.PlatformType", "commentIds", "", "findWithLegacyMentions", "Ljava/util/stream/Stream;", "getAllByAuthorIdAndPostIdIn", "authorId", "postIds", "getById", "id", "insert", "", "postId", "parentId", "referenceId", "createdAt", "updatedAt", "lastUpdatedBy", "jsonContent", "text", "queryAllByParentIdInOrderByCreatedAtAsc", "queryAllByParentIdInOrderByCreatedAtDesc", "updateJsonContent", "json", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostCommentRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostCommentRepo.kt\nde/justsoftware/news/domain/comment/PostCommentRepo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1360#2:219\n1446#2,5:220\n1360#2:225\n1446#2,5:226\n*S KotlinDebug\n*F\n+ 1 PostCommentRepo.kt\nde/justsoftware/news/domain/comment/PostCommentRepo\n*L\n157#1:219\n157#1:220,5\n166#1:225\n166#1:226,5\n*E\n"})
public interface PostCommentRepo
extends CrudRepository<PostComment, CommentId>,
PagingAndSortingRepository<PostComment, CommentId> {
    @Modifying
    @Query(value="\n        INSERT INTO post_comment (id, post_id, parent_id, reference_id, author_id, created_at, updated_at, last_updated_by, json_content, text)\n        VALUES(:id, :postId, :parentId, :referenceId, :authorId, :createdAt, :updatedAt, :lastUpdatedBy, :jsonContent, :text)\n        ")
    public void insert(@Param(value="id") @NotNull CommentId var1, @Param(value="postId") @NotNull PostId var2, @Param(value="parentId") @NotNull ItemId var3, @Param(value="referenceId") @NotNull ItemId var4, @Param(value="authorId") @NotNull ProfileId var5, @Param(value="createdAt") @NotNull Instant var6, @Param(value="updatedAt") @NotNull Instant var7, @Param(value="lastUpdatedBy") @NotNull ProfileId var8, @Param(value="jsonContent") @NotNull String var9, @Param(value="text") @NotNull String var10);

    @Query(value="\n        SELECT post_id as postId, COUNT(*) as count FROM post_comment\n        WHERE post_id in (:postIds)\n        AND deleted = '0'\n        GROUP BY post_id\n        ", rowMapperClass=CountRowMapper.class)
    @NotNull
    public Set<Pair<PostId, Integer>> commentCountByPostIds(@Param(value="postIds") @NotNull Set<String> var1);

    @NotNull
    public PostComment getById(@Param(value="id") @NotNull CommentId var1);

    @NotNull
    default public List<PostComment> findAllByParentId(@NotNull ItemId itemId, @NotNull Sort sort) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        return sort == Sort.ASC ? this.findAllByParentIdOrderByCreatedAtAsc(itemId) : this.findAllByParentIdOrderByCreatedAtDesc(itemId);
    }

    @NotNull
    public List<PostComment> findAllByParentIdOrderByCreatedAtAsc(@Param(value="parentId") @NotNull ItemId var1);

    @NotNull
    public List<PostComment> findAllByParentIdOrderByCreatedAtDesc(@Param(value="parentId") @NotNull ItemId var1);

    @Deprecated(message="Do not use this function directly. Use {@link #findAllByParentIdIn(List)} instead.")
    @NotNull
    public Set<PostComment> queryAllByParentIdInOrderByCreatedAtAsc(@Param(value="parentIds") @NotNull Set<? extends ItemId> var1);

    @Deprecated(message="Do not use this function directly. Use {@link #findAllByParentIdIn(List)} instead.")
    @NotNull
    public Set<PostComment> queryAllByParentIdInOrderByCreatedAtDesc(@Param(value="parentIds") @NotNull Set<? extends ItemId> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Set<PostComment> findAllByParentIdIn(@Param(value="parentIds") @NotNull List<? extends ItemId> parentIds, @NotNull Sort sort) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)parentIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = sort == Sort.ASC ? this.queryAllByParentIdInOrderByCreatedAtAsc(CollectionsKt.toSet((Iterable)it)) : this.queryAllByParentIdInOrderByCreatedAtDesc(CollectionsKt.toSet((Iterable)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Set<PostComment> findAllCommentsById(@NotNull Collection<CommentId> commentIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(commentIds, (String)"commentIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)commentIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable list$iv$iv;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)this.findAllById((Iterable)CollectionsKt.toSet((Iterable)it)), (String)"findAllById(...)");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Set<PostComment> getAllByAuthorIdAndPostIdIn(@NotNull ProfileId var1, @NotNull Collection<PostId> var2);

    @Modifying
    @Query(value="\n        UPDATE post_comment\n        SET deleted = '1', deleted_by = :deletedBy, deleted_at = :deletedAt\n        WHERE id = :commentId\n        ")
    public boolean delete(@Param(value="commentId") @NotNull CommentId var1, @Param(value="deletedBy") @NotNull ProfileId var2, @Param(value="deletedAt") @NotNull Instant var3);

    @Query(value="\n            SELECT *\n            FROM post_comment\n            WHERE deleted ='0' AND json_content LIKE '%mention%' AND json_content NOT LIKE '%denotationChar%'\n        ")
    @NotNull
    public Stream<PostComment> findWithLegacyMentions();

    @Modifying
    @Query(value="\n            UPDATE post_comment SET json_content = :jsonContent WHERE id = :id\n        ")
    public void updateJsonContent(@Param(value="id") @NotNull CommentId var1, @Param(value="jsonContent") @NotNull String var2);
}

