/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.search;

import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.connector.search.SearchConnector;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import io.micrometer.observation.annotation.Observed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Observed
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0012J.\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\b\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000eH\u0016J\u0016\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000eH\u0016J\u0016\u0010 \u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\"H\u0016J>\u0010#\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\f0%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00150%H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/news/connector/search/SearchConnector;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/news/connector/permission/PermissionConnector;)V", "checkSolarAvailability", "", "createChannelSolrDocument", "Lorg/apache/solr/common/SolrInputDocument;", "channel", "Lde/justsoftware/news/domain/channel/Channel;", "visibleForRoles", "", "", "createPostSolrDocument", "post", "Lde/justsoftware/news/domain/post/Post;", "parentChannel", "author", "Lde/justsoftware/news/domain/user/Profile;", "deleteAll", "deleteAllForTenant", "tenantId", "Lde/justsoftware/news/id/TenantId;", "deleteChannels", "channelIds", "Lde/justsoftware/news/id/ChannelId;", "deletePosts", "postIds", "Lde/justsoftware/news/id/PostId;", "upsertChannels", "channels", "", "upsertPosts", "posts", "", "authors", "Lde/justsoftware/news/id/ProfileId;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nSearchConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchConnector.kt\nde/justsoftware/news/connector/search/SearchConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1549#2:141\n1620#2,3:142\n1549#2:145\n1620#2,3:146\n1549#2:149\n1620#2,3:150\n1549#2:153\n1620#2,3:154\n1549#2:157\n1620#2,3:158\n1549#2:161\n1620#2,3:162\n*S KotlinDebug\n*F\n+ 1 SearchConnector.kt\nde/justsoftware/news/connector/search/SearchConnector\n*L\n42#1:141\n42#1:142,3\n44#1:145\n44#1:146,3\n61#1:149\n61#1:150,3\n63#1:153\n63#1:154,3\n72#1:157\n72#1:158,3\n78#1:161\n78#1:162,3\n*E\n"})
public class SearchConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final PermissionConnector permissionConnector;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String SEARCH_TYPE_POST = "POST";
    @NotNull
    private static final String SEARCH_TYPE_CHANNEL = "CHANNEL";
    @NotNull
    private static final String JUST_NEWS_SEARCH_APP_ID = "NEWS";

    public SearchConnector(@NotNull SolrClient solrClient, @NotNull PermissionConnector permissionConnector) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        this.solrClient = solrClient;
        this.permissionConnector = permissionConnector;
    }

    /*
     * WARNING - void declaration
     */
    public void upsertPosts(@NotNull Collection<Post> posts2, @NotNull Map<ChannelId, Channel> channels, @NotNull Map<ProfileId, Profile> authors) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(posts2, (String)"posts");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(authors, (String)"authors");
        if (posts2.isEmpty()) {
            return;
        }
        Iterable iterable = posts2;
        Object object = this.permissionConnector;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map postsToVisibleRoles = object.getRolesWhoRead((Collection)((List)destination$iv$iv));
        Iterable $this$map$iv2 = CollectionsKt.toSet((Iterable)posts2);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post bl = (Post)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            Collection collection = (Collection)postsToVisibleRoles.get(it.getId());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Channel channel = channels.get(it.getChannelId());
            if (channel == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Profile profile = authors.get(it.getAuthorId());
            if (profile == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            object.add(this.createPostSolrDocument((Post)it, collection, channel, profile));
        }
        List solrPostDocs = (List)destination$iv$iv2;
        this.solrClient.add((Collection)solrPostDocs);
        log.info("Success upserting " + solrPostDocs.size() + " Posts.");
    }

    /*
     * WARNING - void declaration
     */
    public void upsertChannels(@NotNull Set<Channel> channels) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        if (channels.isEmpty()) {
            return;
        }
        Iterable iterable = channels;
        Object object = this.permissionConnector;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map channelToVisibleRoles = object.getRolesWhoRead((Collection)((List)destination$iv$iv));
        Iterable $this$map$iv2 = channels;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Channel bl = (Channel)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            Collection collection = (Collection)channelToVisibleRoles.get(it.getId());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            object.add(this.createChannelSolrDocument((Channel)it, collection));
        }
        List solarDocs = (List)destination$iv$iv2;
        this.solrClient.add((Collection)solarDocs);
        log.info("Success upserting " + solarDocs.size() + " Channels.");
    }

    /*
     * WARNING - void declaration
     */
    public void deletePosts(@NotNull Collection<PostId> postIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        if (postIds.isEmpty()) {
            return;
        }
        Iterable iterable = postIds;
        SolrClient solrClient = this.solrClient;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PostId postId = (PostId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        solrClient.deleteById((List)destination$iv$iv);
        log.info("Success deleting Posts.");
    }

    /*
     * WARNING - void declaration
     */
    public void deleteChannels(@NotNull Collection<ChannelId> channelIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        if (channelIds.isEmpty()) {
            return;
        }
        Iterable iterable = channelIds;
        SolrClient solrClient = this.solrClient;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelId channelId = (ChannelId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        solrClient.deleteById((List)destination$iv$iv);
        log.info("Success deleting Channels.");
    }

    public void deleteAllForTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.solrClient.deleteByQuery("just_app_id:NEWS AND tenant_id:" + tenantId.toTypedString());
        log.info("Success deleted all NEWS data for tenant " + tenantId + "..");
    }

    public void deleteAll() {
        this.solrClient.deleteByQuery("just_app_id:NEWS");
        log.info("Success deleted all NEWS data.");
    }

    public void checkSolarAvailability() {
        this.solrClient.ping();
    }

    private SolrInputDocument createPostSolrDocument(Post post, Collection<String> visibleForRoles, Channel parentChannel, Profile author) {
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createPostSolrDocument_u24lambda_u246 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createPostSolrDocument_u24lambda_u246.setField("id", (Object)post.getId().toTypedString());
        $this$createPostSolrDocument_u24lambda_u246.setField("author", (Object)author.getName());
        $this$createPostSolrDocument_u24lambda_u246.setField("name", (Object)post.getTitle());
        $this$createPostSolrDocument_u24lambda_u246.setField("name_sort", (Object)post.getTitle());
        $this$createPostSolrDocument_u24lambda_u246.setField("content", (Object)post.getText());
        $this$createPostSolrDocument_u24lambda_u246.setField("type", (Object)SEARCH_TYPE_POST);
        $this$createPostSolrDocument_u24lambda_u246.setField("direct_parent_ids", (Object)post.getChannelId().toTypedString());
        $this$createPostSolrDocument_u24lambda_u246.setField("parent_ids", (Object)post.getChannelId().toTypedString());
        $this$createPostSolrDocument_u24lambda_u246.setField("parent_name", (Object)parentChannel.getTitle());
        $this$createPostSolrDocument_u24lambda_u246.setField("tenant_id", (Object)parentChannel.getTenantId());
        $this$createPostSolrDocument_u24lambda_u246.setField("modify_date", (Object)Date.from(post.getModifyDate()));
        $this$createPostSolrDocument_u24lambda_u246.setField("publication_date", (Object)Date.from(post.getPublishDate()));
        $this$createPostSolrDocument_u24lambda_u246.setField("just_app_id", (Object)JUST_NEWS_SEARCH_APP_ID);
        $this$createPostSolrDocument_u24lambda_u246.setField("visible_for_roles", visibleForRoles);
        return solrInputDocument;
    }

    private SolrInputDocument createChannelSolrDocument(Channel channel, Collection<String> visibleForRoles) {
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createChannelSolrDocument_u24lambda_u247 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createChannelSolrDocument_u24lambda_u247.setField("id", (Object)channel.getId().toTypedString());
        $this$createChannelSolrDocument_u24lambda_u247.setField("name", (Object)channel.getTitle());
        $this$createChannelSolrDocument_u24lambda_u247.setField("name_sort", (Object)channel.getTitle());
        $this$createChannelSolrDocument_u24lambda_u247.setField("content", (Object)channel.getTitle());
        $this$createChannelSolrDocument_u24lambda_u247.setField("type", (Object)SEARCH_TYPE_CHANNEL);
        $this$createChannelSolrDocument_u24lambda_u247.setField("tenant_id", (Object)channel.getTenantId());
        $this$createChannelSolrDocument_u24lambda_u247.setField("modify_date", (Object)Date.from(channel.getModifyDate()));
        $this$createChannelSolrDocument_u24lambda_u247.setField("publication_date", (Object)Date.from(channel.getCreateDate()));
        $this$createChannelSolrDocument_u24lambda_u247.setField("just_app_id", (Object)JUST_NEWS_SEARCH_APP_ID);
        $this$createChannelSolrDocument_u24lambda_u247.setField("visible_for_roles", visibleForRoles);
        return solrInputDocument;
    }

    static {
        Logger logger = LoggerFactory.getLogger(SearchConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

