/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.notification.service;

import de.justsoftware.mobile.gateway.notification.model.MobilePushToken;
import de.justsoftware.mobile.gateway.notification.model.Notification;
import de.justsoftware.mobile.gateway.notification.model.NotificationsCount;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$archiveNotification$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$getNotifications$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$openNotifications$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$registerAndroid$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$registerIos$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$unregisterPushToken$;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0016\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0016J(\u0010'\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0012J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0003H\u0012J\u0018\u0010)\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0012J\u0010\u0010*\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0012J\u0018\u0010+\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;", "", "notificationApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "archiveAllNotificationsUri", "Ljava/net/URI;", "notificationsCountUri", "openNotificationsUri", "registerAndroidUri", "getNotifications", "", "Lde/justsoftware/mobile/gateway/notification/model/Notification;", "state", "limit", "", "date", "locale", "getNotificationsCount", "Lde/justsoftware/mobile/gateway/notification/model/NotificationsCount;", "archiveAllNotifications", "archiveNotification", "", "notificationId", "openNotifications", "notificationIds", "markNotification", "action", "registerAndroid", "Lde/justsoftware/mobile/gateway/notification/model/MobilePushToken;", "pushToken", "registerIos", "silenceAlerts", "", "unregisterPushToken", "platform", "notificationsUri", "archiveNotificationUri", "markNotificationUri", "registerIosUri", "unregisterPushTokenUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nNotificationApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationApiGatewayService.kt\nde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService\n+ 2 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt\n+ 3 Uris.kt\nde/justsoftware/mobile/gateway/util/UrisKt$buildUri$1\n+ 4 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,121:1\n7#2,5:122\n7#2,5:128\n7#2,5:134\n7#2,5:140\n11#2:155\n7#2,5:156\n7#2,5:162\n11#2:168\n7#2,5:169\n9#3:127\n9#3:133\n9#3:139\n9#3:145\n9#3:161\n9#3:167\n9#3:174\n28#4:146\n28#4:147\n56#4:148\n56#4:149\n59#4:150\n56#4:151\n34#4:152\n34#4:153\n62#4:154\n*S KotlinDebug\n*F\n+ 1 NotificationApiGatewayService.kt\nde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService\n*L\n21#1:122,5\n22#1:128,5\n23#1:134,5\n24#1:140,5\n94#1:155\n102#1:156,5\n108#1:162,5\n111#1:168\n119#1:169,5\n21#1:127\n22#1:133\n23#1:139\n24#1:145\n102#1:161\n108#1:167\n119#1:174\n32#1:146\n41#1:147\n43#1:148\n47#1:149\n50#1:150\n59#1:151\n69#1:152\n75#1:153\n81#1:154\n*E\n"})
public class NotificationApiGatewayService {
    @NotNull
    private final String notificationApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI archiveAllNotificationsUri;
    @NotNull
    private final URI notificationsCountUri;
    @NotNull
    private final URI openNotificationsUri;
    @NotNull
    private final URI registerAndroidUri;

    public NotificationApiGatewayService(@Value(value="${just.notification.api.url}") @NotNull String notificationApiUrl, @NotNull WebClient webClient) {
        UriComponentsBuilder uriComponentsBuilder;
        Intrinsics.checkNotNullParameter((Object)notificationApiUrl, (String)"notificationApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.notificationApiUrl = notificationApiUrl;
        this.webClient = webClient;
        String baseUrl$iv = this.notificationApiUrl + "/notification/archive";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        NotificationApiGatewayService notificationApiGatewayService = this;
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        notificationApiGatewayService.archiveAllNotificationsUri = uRI;
        baseUrl$iv = this.notificationApiUrl + "/notification/count";
        $i$f$buildUri = false;
        uriComponentsBuilder3 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        notificationApiGatewayService = this;
        bl = false;
        URI uRI2 = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"toUri(...)");
        notificationApiGatewayService.notificationsCountUri = uRI2;
        baseUrl$iv = this.notificationApiUrl + "/notification/open";
        $i$f$buildUri = false;
        uriComponentsBuilder3 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        notificationApiGatewayService = this;
        bl = false;
        URI uRI3 = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"toUri(...)");
        notificationApiGatewayService.openNotificationsUri = uRI3;
        baseUrl$iv = this.notificationApiUrl + "/mobilepush/android";
        $i$f$buildUri = false;
        uriComponentsBuilder3 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        notificationApiGatewayService = this;
        bl = false;
        URI uRI4 = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI4, (String)"toUri(...)");
        notificationApiGatewayService.registerAndroidUri = uRI4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Notification> getNotifications(@NotNull String state, int limit, @NotNull String date, @NotNull String locale) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        WebClient webClient = this.webClient;
        URI uRI = this.notificationsUri(state, limit, date, locale);
        boolean $i$f$get = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getNotifications$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NotificationsCount getNotificationsCount() {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.notificationsCountUri;
        boolean $i$f$get = false;
        return (NotificationsCount)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> archiveAllNotifications() {
        void $this$put$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.archiveAllNotificationsUri;
        boolean $i$f$put = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void archiveNotification(@NotNull String notificationId) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.archiveNotificationUri(notificationId);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new archiveNotification$$inlined$put$1((WebClient)$this$put$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void openNotifications(@NotNull List<String> notificationIds) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        WebClient webClient = this.webClient;
        URI uri$iv = this.openNotificationsUri;
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new openNotifications$$inlined$put$1((WebClient)$this$put$iv, uri$iv, notificationIds, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void markNotification(@NotNull String notificationId, @NotNull String action) {
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        WebClient webClient = this.webClient;
        URI uRI = this.markNotificationUri(notificationId, action);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobilePushToken registerAndroid(@NotNull String pushToken) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uri$iv = this.registerAndroidUri;
        boolean $i$f$post = false;
        return (MobilePushToken)BuildersKt.runBlocking$default(null, (Function2)((Function2)new registerAndroid$$inlined$post$1((WebClient)$this$post$iv, uri$iv, (Object)pushToken, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobilePushToken registerIos(@NotNull String pushToken, boolean silenceAlerts) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uri$iv = this.registerIosUri(silenceAlerts);
        boolean $i$f$post = false;
        return (MobilePushToken)BuildersKt.runBlocking$default(null, (Function2)((Function2)new registerIos$$inlined$post$1((WebClient)$this$post$iv, uri$iv, (Object)pushToken, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterPushToken(@NotNull String platform, @NotNull String pushToken) {
        void uri$iv;
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uRI = this.unregisterPushTokenUri(platform, pushToken);
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new unregisterPushToken$$inlined$delete$1((WebClient)$this$delete$iv, (URI)uri$iv, null)), (int)1, null);
    }

    private URI notificationsUri(String state, int limit, String date, String locale) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder $this$notificationsUri_u24lambda_u240 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        Object[] objectArray = new Object[]{state};
        $this$notificationsUri_u24lambda_u240.queryParam("status", objectArray);
        objectArray = new Object[]{limit};
        $this$notificationsUri_u24lambda_u240.queryParam("maxElements", objectArray);
        objectArray = new Object[]{date};
        $this$notificationsUri_u24lambda_u240.queryParam("date", objectArray);
        objectArray = new Object[]{locale};
        $this$notificationsUri_u24lambda_u240.queryParam("locale", objectArray);
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI archiveNotificationUri(String notificationId) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification/archive/" + notificationId;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI markNotificationUri(String notificationId, String action) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/notification/" + notificationId + "/" + action;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI registerIosUri(boolean silenceAlerts) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/mobilepush/ios";
        boolean $i$f$buildUri = false;
        UriComponentsBuilder $this$registerIosUri_u24lambda_u241 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        Object[] objectArray = new Object[]{silenceAlerts};
        $this$registerIosUri_u24lambda_u241.queryParam("silenceAlerts", objectArray);
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }

    private URI unregisterPushTokenUri(String platform, String pushToken) {
        UriComponentsBuilder uriComponentsBuilder;
        String baseUrl$iv = this.notificationApiUrl + "/mobilepush/" + platform + "/" + pushToken;
        boolean $i$f$buildUri = false;
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl$iv);
        boolean bl = false;
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2;
        URI uRI = uriComponentsBuilder.encode(StandardCharsets.UTF_8).build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return uRI;
    }
}

